#
# This file is auto-generated. ***ANY*** changes here will be lost
#

package Errno;
use vars qw(@EXPORT_OK %EXPORT_TAGS @ISA $VERSION %errno $AUTOLOAD);
use Exporter ();
use Config;
use strict;

$Config{'myarchname'} eq "mc68040-aux" or
	die "Errno architecture (mc68040-aux) does not match executable architecture ($Config{'myarchname'})";

$VERSION = "1.111";
@ISA = qw(Exporter);

@EXPORT_OK = qw(EFAULT ENOSYS ENETDOWN EAFNOSUPPORT ENOEXEC EALREADY
	EMSGSIZE ENOENT ECHILD EDEADLK EL2HLT EL2NSYNC ENOTBLK EISCONN EIDRM
	EEXIST ERANGE ECONNABORTED ECHRNG EUSERS EDESTADDRREQ EXDEV ESTALE
	ELOOP EISDIR ENODEV ENOCSI ESHUTDOWN ECONNREFUSED ENOTTY
	ESOCKTNOSUPPORT EADDRINUSE ENOTEMPTY ESPIPE EUNATCH ENOMSG E2BIG
	ENOPROTOOPT EREMOTE ENETUNREACH EPIPE ENOTDIR ECONNRESET EPROCLIM
	ENODATA EFBIG EIO EADDRNOTAVAIL EROFS EINVAL EACCES ENOTCONN EAGAIN
	ENOSPC ENAMETOOLONG EHOSTUNREACH EMFILE EBADF ENOBUFS ETXTBSY ENFILE
	ETIME EPFNOSUPPORT EWOULDBLOCK ENOSTR ENOLCK EL3RST EMLINK ENOMEM
	EINTR ENXIO EDOM ENOTSOCK ELNRNG ENOSR EBUSY EL3HLT ENETRESET
	ETIMEDOUT EINPROGRESS EDQUOT EPROTONOSUPPORT ESRCH EPERM EPROTOTYPE
	EHOSTDOWN ETOOMANYREFS EDEADLOCK EOPNOTSUPP);

%EXPORT_TAGS = (
    POSIX => [qw(
	E2BIG EACCES EADDRINUSE EADDRNOTAVAIL EAFNOSUPPORT EAGAIN EALREADY
	EBADF EBUSY ECHILD ECONNABORTED ECONNREFUSED ECONNRESET EDEADLK
	EDESTADDRREQ EDOM EDQUOT EEXIST EFAULT EFBIG EHOSTDOWN EHOSTUNREACH
	EINPROGRESS EINTR EINVAL EIO EISCONN EISDIR ELOOP EMFILE EMLINK
	EMSGSIZE ENAMETOOLONG ENETDOWN ENETRESET ENETUNREACH ENFILE ENOBUFS
	ENODEV ENOENT ENOEXEC ENOLCK ENOMEM ENOPROTOOPT ENOSPC ENOSYS ENOTBLK
	ENOTCONN ENOTDIR ENOTEMPTY ENOTSOCK ENOTTY ENXIO EOPNOTSUPP EPERM
	EPFNOSUPPORT EPIPE EPROCLIM EPROTONOSUPPORT EPROTOTYPE ERANGE EREMOTE
	EROFS ESHUTDOWN ESOCKTNOSUPPORT ESPIPE ESRCH ESTALE ETIMEDOUT
	ETOOMANYREFS ETXTBSY EUSERS EWOULDBLOCK EXDEV
    )]
);

sub EPERM () { 1 }
sub ENOENT () { 2 }
sub ESRCH () { 3 }
sub EINTR () { 4 }
sub EIO () { 5 }
sub ENXIO () { 6 }
sub E2BIG () { 7 }
sub ENOEXEC () { 8 }
sub EBADF () { 9 }
sub ECHILD () { 10 }
sub EAGAIN () { 11 }
sub ENOMEM () { 12 }
sub EACCES () { 13 }
sub EFAULT () { 14 }
sub ENOTBLK () { 15 }
sub EBUSY () { 16 }
sub EEXIST () { 17 }
sub EXDEV () { 18 }
sub ENODEV () { 19 }
sub ENOTDIR () { 20 }
sub EISDIR () { 21 }
sub EINVAL () { 22 }
sub ENFILE () { 23 }
sub EMFILE () { 24 }
sub ENOTTY () { 25 }
sub ETXTBSY () { 26 }
sub EFBIG () { 27 }
sub ENOSPC () { 28 }
sub ESPIPE () { 29 }
sub EROFS () { 30 }
sub EMLINK () { 31 }
sub EPIPE () { 32 }
sub EDOM () { 33 }
sub ERANGE () { 34 }
sub ENOMSG () { 35 }
sub EIDRM () { 36 }
sub ECHRNG () { 37 }
sub EL2NSYNC () { 38 }
sub EL3HLT () { 39 }
sub EL3RST () { 40 }
sub ELNRNG () { 41 }
sub EUNATCH () { 42 }
sub ENOCSI () { 43 }
sub EL2HLT () { 44 }
sub EDEADLK () { 45 }
sub EWOULDBLOCK () { 55 }
sub EINPROGRESS () { 56 }
sub EALREADY () { 57 }
sub ENOTSOCK () { 58 }
sub EDESTADDRREQ () { 59 }
sub EMSGSIZE () { 60 }
sub EPROTOTYPE () { 61 }
sub ENOPROTOOPT () { 62 }
sub EPROTONOSUPPORT () { 63 }
sub ESOCKTNOSUPPORT () { 64 }
sub EOPNOTSUPP () { 65 }
sub EPFNOSUPPORT () { 66 }
sub EAFNOSUPPORT () { 67 }
sub EADDRINUSE () { 68 }
sub EADDRNOTAVAIL () { 69 }
sub ENETDOWN () { 70 }
sub ENETUNREACH () { 71 }
sub ENETRESET () { 72 }
sub ECONNABORTED () { 73 }
sub ECONNRESET () { 74 }
sub ENOBUFS () { 75 }
sub EISCONN () { 76 }
sub ENOTCONN () { 77 }
sub ESHUTDOWN () { 78 }
sub ETOOMANYREFS () { 79 }
sub ETIMEDOUT () { 80 }
sub ECONNREFUSED () { 81 }
sub ELOOP () { 82 }
sub ENAMETOOLONG () { 83 }
sub EHOSTDOWN () { 84 }
sub EHOSTUNREACH () { 85 }
sub ENOTEMPTY () { 86 }
sub ENOSTR () { 87 }
sub ENODATA () { 88 }
sub ETIME () { 89 }
sub ENOSR () { 90 }
sub ESTALE () { 95 }
sub EREMOTE () { 96 }
sub EPROCLIM () { 97 }
sub EUSERS () { 98 }
sub EDQUOT () { 99 }
sub EDEADLOCK () { 100 }
sub ENOLCK () { 101 }
sub ENOSYS () { 102 }

sub TIEHASH { bless [] }

sub FETCH {
    my ($self, $errname) = @_;
    my $proto = prototype("Errno::$errname");
    if (defined($proto) && $proto eq "") {
	no strict 'refs';
        return $! == &$errname;
    }
    require Carp;
    Carp::confess("No errno $errname");
} 

sub STORE {
    require Carp;
    Carp::confess("ERRNO hash is read only!");
}

*CLEAR = \&STORE;
*DELETE = \&STORE;

sub NEXTKEY {
    my($k,$v);
    while(($k,$v) = each %Errno::) {
	my $proto = prototype("Errno::$k");
	last if (defined($proto) && $proto eq "");
	
    }
    $k
}

sub FIRSTKEY {
    my $s = scalar keys %Errno::;
    goto &NEXTKEY;
}

sub EXISTS {
    my ($self, $errname) = @_;
    my $proto = prototype($errname);
    defined($proto) && $proto eq "";
}

tie %!, __PACKAGE__;

1;
__END__

=head1 NAME

Errno - System errno constants

=head1 SYNOPSIS

    use Errno qw(EINTR EIO :POSIX);

=head1 DESCRIPTION

C<Errno> defines and conditionally exports all the error constants
defined in your system C<errno.h> include file. It has a single export
tag, C<:POSIX>, which will export all POSIX defined error numbers.

C<Errno> also makes C<%!> magic such that each element of C<%!> has a non-zero
value only if C<$!> is set to that value, eg

    use Errno;
    
    unless (open(FH, "/fangorn/spouse")) {
        if ($!{ENOENT}) {
            warn "Get a wife!\n";
        } else {
            warn "This path is barred: $!";
        } 
    } 

=head1 AUTHOR

Graham Barr <gbarr@pobox.com>

=head1 COPYRIGHT

Copyright (c) 1997-8 Graham Barr. All rights reserved.
This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

