#if !defined(__sys_gdkernel_h)
#define __sys_gdkernel_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/gdkernel.h        1.17 93/12/15 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

#if !defined(__sys_types_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:types.h"
# else
#   include <sys/types.h>
# endif
#endif 

#if !defined(__sys_erec_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:erec.h"
# else
#   include <sys/erec.h>
# endif
#endif 

#if !defined(__sys_vio_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:vio.h"
# else
#   include <sys/vio.h>
# endif
#endif 

#if !defined(__sys_iobuf_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:iobuf.h"
# else
#   include <sys/iobuf.h>
# endif
#endif 

#if !defined(__sys_gdisk_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:gdisk.h"
# else
#   include <sys/gdisk.h>
# endif
#endif 

/*
 *	Generic Disk Driver Interface
 *
 *	that information of interest to the kernel
 *
 *      Copyright 1987 UniSoft Corporation
 */

struct gdctl {		 /* 	Controller data structure */
	struct genprocs *ctprocs;	/* generic low level procs */
	struct gentask	*cttaskp;	/* pointer to current task list */
	int	ctflags;		/* flags for handling controller */
	struct gddrive *ctdrive;	/* drive list */
	struct gddrive *ctactive;	/* currently active drive */
	struct gdctl *ctnextct;		/* list of ctl structures */
	int	ctcmd;			/* Command associated with ctbp */
	long	ctarg;			/* argument for current command */
	int	(*ctdevctl)();		/* function to be called for devctl */
	int	ctretval;		/* return value of command */
	daddr_t	ctsector;		/* private for generic code */
	daddr_t	ctlbn;			/* logical block for error msgs */
#ifdef	STANDALONE
	char	ctbuf[1024];		/* Scratch buffer area */
#else
	struct	buf *ctbp;		/* allocated scratch buffer */
	struct	deverreg cterr[4];	/* Scratch for error messages */
	short	cterrind;		/* index into error message storage */
#endif
	char	ctrunning;		/* True if start routine active */
	char	ctpending;		/* True if any device has a request */
	short	ctstate;		/* generic code private data */
	short	ctretry;		/* retry counter for soft errors */
	short	ctmajor;		/* major device number from devsw */
	};

/*	Commands.  These are special commands (not Input or Output) which
 *	may be performed on a disk.  These internal codes are passed between
 *	the ioctl and start routines.
 */

#define	GDC_INIT	1	/* initialize drive and partition info */
#define	GDC_FMT		2	/* format drive */
#define	GDC_RDDPME	3	/* read dpme for a partition */
#define	GDC_WRDPME	4	/* write out dpme */
#define	GDC_RDALTS	5	/* read an alt block entry */
#define	GDC_IDLE	6	/* stop activity and awaken context */
#define	GDC_FINISH	7	/* Command is finished, mark buffer as done */
#define	GDC_DEVCTL	8	/* Call dev specific control routine */

/*	Controller flags.
 */

#define	CTF_NOPRINT	0x1	/* If true, disable error printing to console */
#define	CTF_CLOSING	0x2	/* If true, device is closing */
#define	CTF_CDROM  	0x4	/* If true, device is readonly CD-ROM */
#define	CTF_CD300  	0x8	/* If true, device is K2 CD-ROM 300 */
#define	CTF_GCD  	0x10	/* If true, device (CDROM) uses 2K blk size */
#define	CTF_REMOVABLE  	0x20	/* If true, device is removable */
#define	CTF_RDONLY  	0x40	/* If true, device is read-only */

/*	Genprocs.  This data structure defines the actions defined by the low
 *	level device specific code.  The generic driver accesses the
 *	hardware only through these calls.
 */

struct	genprocs {		/* pointers to device specific routines */
	int	(*gpread)();		/* read data */
	int	(*gpwrite)();		/* write data */
	int	(*gpdriveinit)();	/* initialize data structures */
	int	(*gpbadblock)();	/* map bad block */
	int	(*gpformat)();		/* format drive */
	int	(*gprecover)();		/* recover following an error */
	int	(*gpshutdown)();	/* stop processing, or eject */
	int	(*gpdriveinfo)();	/* return drive info */
	};

/*	Error returns from device specific routines.
 *	    A function called out of genprocs will "call back" with one of these
 *	values.
 */

#define	GDR_OK	0	/* everything worked */
#define	GDR_AGAIN 1	/* a correctable error happened, try again */
#define	GDR_CORR 2	/* an error was corrected.  Everything's ok now */
#define GDR_FAILED 3	/* The operation did not work */
#define GDR_QRECOVER 4	/* quietly recover CD300 medium error */

/*	Task structure describing a single read or write operation to
 *	be performed by device specific routines.
 */

struct gentask {
	int	(*gtretproc)();		/* address of completion function */
	struct	gdctl *gtcp;		/* pointer back to controller */
	struct	drqual *gtqual;		/* device qualities pointer */
	caddr_t gtaddr;			/* address of buffer to fill */
	struct  vio gtvio;		/* address vectors if B_VIO */
	int	gtnreq;			/* number of bytes requested */
	int	gtndone;		/* number of bytes read or written */
	int	gtvdone;		/* number of vio vects processed */
	daddr_t	gtblock;		/* block number to read or write */
	short	gtmaj;			/* device major number */
	short	gtdnum;			/* disk number */
	};

struct gddrive {		/* description of a single spindle */
	struct gddrive *drnxt;		/* next drive on controller */
	struct drqual *drqual;		/* qualities of device */
	short	drstate;		/* drive state from generic code */
	short	drpartnum;		/* which partition are we working on */
	int	drcount;		/* count for EOF calculation */
	int	drniov;			/* count for VIO calculation */
	u_char	drnum;			/* device unit number */
#ifndef	STANDALONE
	struct	iobuf drtab;		/* I/O queue header */
	struct	iostat driostat;	/* I/O error handling */
#endif
	struct gdpart *drpart[GD_MAXPART];  /* pointers to partition info */
	};

#define	DRS_NOTINIT 0	/* device has never been acessed */
#define DRS_REINIT  1	/* must be reinitialized next access */
#define DRS_STARTING 2	/* in the process of initializing */
#define DRS_NORMAL 3	/* everything is ok */

struct	drqual {	/* description of device qualities */
	long	dqdevp;		/* device specific storage */
	int dqflags;		/* Flag Values */
	u_long dqxfermax;	/* maximum number of bytes per xfer */
	short dqcyl;		/* number of sectors per cylinder */
				/* negative for no cylinder boundaries */
	u_short dqblksize;	/* unused in first release */
	daddr_t dqmaxbn;	/* maximum block number for device */
	};

/*	Symbols for dqflags field.
 *	     Bits zero through 15 of the word are for device specific drive
 *	code.
 */

#define	DQF_NOCORR 0x10000	/* Correctable errors return as hard errors */

struct	gdpart {		/* description of a mounted partition */
	long ptflags;		/* various flags */
	daddr_t	ptdpme;		/* disk address of dpme entry */
	daddr_t ptoffset;	/* physical address of first block */
	daddr_t ptlsize;	/* logical size of data partition */
	daddr_t ptpsize;	/* total size of partition */
	daddr_t ptastart;	/* location of alt block map */
	int	ptasize;	/* size of alt block map (in bytes) */
	int	ptaents;	/* number of entries in alt block (in bytes) */
	short	ptstate;	/* state information */
	struct  bbhdr *ptbm;	/* bad block bucket list for partition */
	short	ptbmask;	/* mask for bucket hashing */
	char	ptname[32];	/* name of partition */
	char	pttype[32];	/* name of partition */
	char	ptcluster;	/* eschatology cluster of partition */
	};

#define	PTF_NOALT 1		/* alt block mapping is off */
#define PTF_USERALT 2		/* User has explicitly turned off alt block */
#define	PTF_ESCH0 4		/* Partition is default esch. cluster */
#define	PTF_RONLY 8		/* Read only file system */
			/* Partition type information */
#define PTF_TYMASK	0x30	/* Mask for type info */
#define PTF_TYPHYS	0x10	/* not a partition, eg whole device */
#define	PTF_TYDEF	0x20	/* There are no partitions, default alloc */
#define	PTF_TYDPME	0x30	/* Partition assigned from a DPME */
			/* Partition name information */
#define	PTF_NMMASK	0x300
#define	PTF_NMNONE 	0x000	/* This number has no partition assigned */
#define PTF_NMUSER 	0x100	/* name/number assigned by user ioctl */
#define PTF_NMDEF 	0x200	/* name/number assigned by default */

#define PTS_REINIT 0		/* Re initialize on next access */
#define PTS_STARTING 1		/* Initialization in progress */
#define PTS_NEEDALT 2		/* alt block processing required */
#define PTS_ALTING 3		/* alt block processing in progress */
#define PTS_NORMAL 4		/* active and ok */

struct	bbhdr {	/* in core bad block bucket array header */
	struct bbent *blist;	/* bad block entries for the bucket */
	short	bunum;		/* number of bad block entries */
	};

struct	bbent {		/* in core data representation of bad block spare */
	daddr_t bmfailed;	/* logical address of failed block */
	daddr_t bmrepl;		/* physical address of replacement */
	};

#if	(defined(KERNEL) || defined(STANDALONE))
struct gdctl *gdctlinit();
#endif	
#ifdef	STANDALONE
#define	CLUSTER 1	/* ZZZ test mechanism for obtaining current cluster */
#else
#define CLUSTER	((struct kernel_info *)v.v_kernel_info)->root_cluster
#endif

#ifdef	STANDALONE
#define	kmem_alloc(n) malloc(n)
#define	kmem_free(a, n) free(a)
#define	GDPRINTF	if(!(ctp->ctflags & CTF_NOPRINT)) sa_printf
#define	printf		sa_printf

#else
#define	GDPRINTF	if(!(ctp->ctflags & CTF_NOPRINT))printf

#define	GD_SCRBUF(ctp)	((ctp)->ctbp->b_un.b_addr)
#endif

#endif /* __sys_gdkernel_h */
