
/*
 *	Copyright (c) 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)zip.h: 2.0, 1.8; 7/10/91; Copyright 1988-89, Apple Computer, Inc. */

#ifndef __ZIP__
#define	__ZIP__

/* Definitions for ZIP, per AppleTalk Zone Information Protocol
 * documentation from `Inside AppleTalk', July 14, 1986.
 */

#if defined(__MPW_C__)
# include "/:usr:include:at:nbp.h"
#else
# include <at/nbp.h>
#endif

/* ZIP DDP socket type */

#define ZIP_SOCKET		6  	/* ZIP socket number */

/* ZIP packet types */

#define ZIP_DDP_TYPE		6  	/* ZIP packet */

#define ZIP_QUERY         	1  	/* ZIP zone query packet */
#define ZIP_REPLY           	2  	/* ZIP query reply packet */
#define ZIP_TAKEDOWN        	3  	/* ZIP takedown packet */
#define ZIP_BRINGUP        	4  	/* ZIP bringup packet */
#define ZIP_GETNETINFO		5	/* ZIP DDP get net info packet */
#define	ZIP_NETINFO_REPLY	6	/* ZIP GetNetInfo Reply */
#define ZIP_NOTIFY		7	/* Notification of zone name change */

#define ZIP_GETMYZONE    	7  	/* ZIP ATP get my zone packet */
#define ZIP_GETZONELIST    	8  	/* ZIP ATP get zone list packet */
#define	ZIP_GETLOCALZONES	9	/* ZIP ATP get cable list packet*/

#define ZIP_HDR_SIZE		2
#define	ZIP_DATA_SIZE		584

typedef	struct at_zip {
	u_char	command;
	u_char	flags;
	char	data[ZIP_DATA_SIZE];
} at_zip_t;

#define	 ZIP_ZIP(c)	((at_zip_t *)(&((at_ddp_t *)(c))->data[0]))

/* ioctl codes */
#define	ZIP_IOC_MYIOCTL(i)	((i>>8) == AT_MID_ZIP)
#define	ZIP_IOC_GET_CFG		((AT_MID_ZIP<<8) | 1)

typedef struct {
	at_nvestr_t	zonename;
} at_zip_cfg_t;

#endif
