
/*
 *	Copyright (c) 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)rtmp.h: 2.0, 1.4; 7/17/89; Copyright 1988-89, Apple Computer, Inc. */

/* RTMP DDP socket number */
#define RTMP_SOCKET		0x01	/* RTMP socket number 	*/


/* RTMP packet types */
#define RTMP_DDP_TYPE		0x01	/* RTMP packet 		*/
#define RTMP_REQ		0x05	/* RTMP request packet	*/


#define RTMP_ROUTER_AGE		50	/* Number of seconds to age router */

/* RTMP response and data packet format */

typedef struct {
        at_net  	at_rtmp_this_net;
        u_char      	at_rtmp_id_length;
        u_char      	at_rtmp_id[1];
} at_rtmp;

/* RTMP network/distance data tuples */

#define RTMP_TUPLE_SIZE		3

/* Extended AppleTalk tuple can be thought of as two of
 * these tuples back to back.
 */

typedef struct {
	at_net		at_rtmp_net;
#if defined(__vax__) || defined(sequent) || defined(__sun386__)
	u_char  	at_rtmp_distance : 4,
			unused : 3,
			at_rtmp_range_flag : 4;
#else
	u_char  	at_rtmp_range_flag : 1,
			unused : 3,
			at_rtmp_distance : 4;
#endif
} at_rtmp_tuple;

