
/*
 *	Copyright (c) 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)lap.h: 2.0, 1.4; 2/16/90; Copyright 1988-89, Apple Computer, Inc. */

/* Definitions for generic access to AppleTalk link level protocols.
 */

#ifndef __LAP__
#define __LAP__

	struct atalk_addr {
		union {
			struct	{
				u_char	unused;
				u_char	net0;
				u_char	net1;
				at_node	node;
			} four_bytes;
			u_int	int_addr;
		} atalk_union;
#define atalk_unused	atalk_union.four_bytes.unused
#define	atalk_net	atalk_union.four_bytes.net0
#define	atalk_node	atalk_union.four_bytes.node
#define	at_uiaddr	atalk_union.int_addr
	};


#define AT_IFF_IFMASK		0xffff	/* lower 16 bits define interface type*/
#define	AT_IFF_LOCALTALK	0x1	/* This is a LocalTalk interface */
#define	AT_IFF_ETHERTALK	0x2	/* This is a LocalTalk interface */
#define AT_IFF_DEFAULT		0x40000

/* Generic LAP ioctl's.  Each LAP may implement other ioctl's specific to
 * its functionality.
 */
#define	LAP_IOC_MYIOCTL(i)	((i>>8) == AT_MID_LAP)
#define	LAP_IOC_ONLINE		((AT_MID_LAP<<8) | 1)
#define	LAP_IOC_OFFLINE		((AT_MID_LAP<<8) | 2)

#endif

