
/*
 *	Copyright (c) 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)elap.h: 2.0, 1.8; 12/12/91; Copyright 1988-89, Apple Computer, Inc. */

#ifndef __ELAP__
#define __ELAP__

#if defined(__MPW_C__)
# include "/:usr:include:at:lap.h"
#else
# include <at/lap.h>
#endif
#if defined(__MPW_C__)
# include "/:usr:include:at:nbp.h"
#else
# include <at/nbp.h>
#endif

/* ethernet address used by ethertalk - 48 bits
 */

#define  AT_ETHER_HDR_SIZE              14  /* Ethernet header size          */
#define  AT_IF_NAME_LEN                  4  /* interface name length          */

struct etalk_addr {
	u_char 		etalk_addr_octet[6];	
};

typedef	struct {
	struct etalk_addr	dest_addr;
	struct etalk_addr	src_addr;
	u_short			length;
} etalk_header_t;

typedef struct {
	u_int	unknown_mblks;	/* number of unknown streams msgs	*/
	u_int	rcv_bytes;  	/* number of data bytes received	*/
	u_int	rcv_packets;	/* number of packets received		*/
	u_int	xmit_bytes;	/* number of data bytes xmited		*/
	u_int	xmit_packets;	/* number of packets xmited		*/
} at_elap_stats_t;

typedef struct {
        short			network_up;	/* 0=network down, nonzero up.*/
        struct	atalk_addr	node;		/* Our node number.           */
	struct	atalk_addr	initial_addr;
	at_nvestr_t		zonename;
	char			if_name [4];
} at_elap_cfg_t;

#define	ELAP_IOC_MYIOCTL(i)	((i>>8) == AT_MID_ELAP)
#define	ELAP_IOC_GET_CFG	((AT_MID_ELAP<<8) | 1)
#define	ELAP_IOC_GET_STATS	((AT_MID_ELAP<<8) | 2)
#define	ELAP_IOC_SET_CFG	((AT_MID_ELAP<<8) | 3)
#define	ELAP_IOC_SET_ZONE	((AT_MID_ELAP<<8) | 4)
#define	ELAP_IOC_SWITCHZONE	((AT_MID_ELAP<<8) | 5)

#endif


