
/*
 *	Copyright (c) 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)at_atp.h: 2.0, 1.11; 10/4/93; Copyright 1988-89, Apple Computer, Inc. */

/* Definitions for ATP protocol and streams module, per 
 * AppleTalk Transaction Protocol documentation from
 * `Inside AppleTalk', July 14, 1986.
 */


#ifndef __ATP__
#define __ATP__

#ifndef UIOSEG_USER
#if defined(__MPW_C__)
# include "/:usr:include:sys:uio.h"
#else
# include <sys/uio.h>
#endif
#endif


/* DDP ATP protocol type */

#define  AT_DDP_TYPE_ATP        0x03 	/* ATP packet type */


/* ATP function codes */

#define AT_ATP_CMD_TREQ        0x01	/* TRequest packet  */
#define AT_ATP_CMD_TRESP       0x02	/* TResponse packet */
#define AT_ATP_CMD_TREL        0x03	/* TRelease packet  */


/* Miscellaneous definitions */

#define	AT_ATP_DEF_RETRIES     8	/* Default for maximum retry count */
#define	AT_ATP_DEF_INTERVAL    2	/* Default for retry interval in seconds */

#define AT_ATP_TRESP_MAX       8	/* Maximum number of Tresp pkts */

#define AT_ATP_HDR_SIZE        8  	/* Size of the ATP header */
#define AT_ATP_DATA_SIZE       578  	/* Maximum size of the ATP data area */
#define ATP_HDR_SIZE          (AT_ATP_HDR_SIZE+DDP_X_HDR_SIZE)
#define ATP_ATP_HDR(c)        ((at_atp *)(&((at_ddp_t *)(c))->data[0]))
#define ATP_CLEAR_CONTROL(c)  (*(char *)(c) = 0)

typedef struct {
        u_char         at_atp_cmd : 2;
        u_char         at_atp_xo : 1;
        u_char         at_atp_eom : 1;
        u_char         at_atp_sts : 1;
        u_char         at_atp_unused : 3;
        u_char         at_atp_bitmap_seqno;
	u_short        at_atp_transaction_id;
        u_char         at_atp_user_bytes[4];
        u_char         at_atp_data[AT_ATP_DATA_SIZE];
} at_atp;


/* Response buffer structure for atp_sendreq() and atp_sendrsp() */

typedef	struct	at_resp {
	u_char	bitmap;				/* Bitmap of expected responses */
	struct	iovec resp[AT_ATP_TRESP_MAX];	/* Buffer for response data */
	long	userdata[AT_ATP_TRESP_MAX];	/* Buffer for response user data */
} at_resp_t;



/* ATP ioctl interface */


/* Structure for the atp_set_default call */

#define	ATP_INFINITE_RETRIES	0xffffffff	/* means retry forever
						 * in the def_retries field
					 	 */

struct atp_set_default {
	u_int	def_retries;		/* number of retries for a request */
	u_int	def_rate;		/* retry rate (in seconds/100) NB: the
					 * system may not be able to resolve
					 * delays of 100th of a second but will
					 * instead make a 'best effort'
					 */
	struct atpBDS *def_bdsp; /*  BDS structure associated with this req */
	u_int	def_BDSlen;	/* size of BDS structure */
};


/* Return header from requests */

struct atp_result {
	u_short		count;		/* the number of packets */
	u_short		hdr;		/* offset to header in buffer */
	u_short 	offset[8];	/* offset to the Nth packet in the buffer */
	u_short		len[8];		/* length of the Nth packet */
};

struct atpBDS {
	unsigned short	bdsBuffSz;
	char *		bdsBuffAddr;
	unsigned short	bdsDataSz;
	unsigned char	bdsUserData[4];
};


typedef struct {
        u_short        at_atpreq_type;
        at_net         at_atpreq_to_net;
        at_node        at_atpreq_to_node;
        at_socket      at_atpreq_to_socket;
        u_char         at_atpreq_treq_user_bytes[4];
        u_char         *at_atpreq_treq_data;
        u_short        at_atpreq_treq_length;
        u_char         at_atpreq_treq_bitmap;
        u_char         at_atpreq_xo;
        u_short        at_atpreq_retry_timeout;
        u_short        at_atpreq_maximum_retries;
        u_char         at_atpreq_tresp_user_bytes[AT_ATP_TRESP_MAX][4];
        u_char         *at_atpreq_tresp_data[AT_ATP_TRESP_MAX];
        u_short        at_atpreq_tresp_lengths[AT_ATP_TRESP_MAX];
        u_long         at_atpreq_debug[4];
        u_short        at_atpreq_tid;
        u_char         at_atpreq_tresp_bitmap;
        u_char         at_atpreq_tresp_eom_seqno;
        u_char         at_atpreq_got_trel;
} at_atpreq;


/* The ATP module ioctl commands */

#define	AT_ATP_CANCEL_REQUEST		(('|'<<8)|1)
#define	AT_ATP_ISSUE_REQUEST		(('|'<<8)|2)
#define	AT_ATP_ISSUE_REQUEST_DEF	(('|'<<8)|3)
#define	AT_ATP_ISSUE_REQUEST_DEF_NW	(('|'<<8)|4)
#define	AT_ATP_ISSUE_REQUEST_DEF_NOTE	(('|'<<8)|5)
#define	AT_ATP_ISSUE_REQUEST_NOTE	(('|'<<8)|6)
#define	AT_ATP_ISSUE_REQUEST_NW		(('|'<<8)|7)
#define	AT_ATP_GET_REQUEST		(('|'<<8)|8)
#define	AT_ATP_GET_REQUEST_NOTE		(('|'<<8)|9)
#define	AT_ATP_GET_REQUEST_NW		(('|'<<8)|10)
#define	AT_ATP_GET_POLL			(('|'<<8)|11)
#define	AT_ATP_POLL_REQUEST		(('|'<<8)|12)
#define	AT_ATP_RELEASE_RESPONSE		(('|'<<8)|13)
#define	AT_ATP_SEND_RESPONSE		(('|'<<8)|14)
#define	AT_ATP_SEND_RESPONSE_EOF	(('|'<<8)|15)
#define	AT_ATP_SET_DEFAULT		(('|'<<8)|16)
#define	AT_ATP_SET_FINISH		(('|'<<8)|17)
#define	AT_ATP_SET_FINISH_RESP		(('|'<<8)|18)
#define	AT_ATP_SET_FINISH_REQ		(('|'<<8)|19)
#define AT_ATP_REQUEST_COMPLETE		(('|'<<8)|20)
#define AT_ATP_SEND_FULL_RESPONSE	(('|'<<8)|21)
#define AT_ATP_SET_SOCKET_MAP           (('|'<<8)|22)


/* These macros don't really depend here, but since they're used only by the
 * old ATP and old PAP, they're put here.  Unisoft PAP includes this file.
 */
#define	R16(x)		x
#define	W16(x,v)	x=v
#define	C16(x,v)	x=v


/*
 * these are the dispatch codes for
 * the new atp_control system call
 */
#define ATP_SENDREQUEST  0
#define ATP_GETRESPONSE  1
#define ATP_SENDRESPONSE 2
#define ATP_GETREQUEST   3

#endif
