#if !defined(__unistd_h)
#define __unistd_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:unistd.h	1.23 91/10/11 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-90 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1984-85 AT&T */
  
#ifdef _SYSV_SOURCE
/* lockf(..., function, ...) values */
#define F_ULOCK	0	/* Unlock a previously locked region */
#define F_LOCK	1	/* Lock a region for exclusive use */
#define F_TLOCK	2	/* Test and lock a region for exclusive use */
#define F_TEST	3	/* Test a region for other processes locks */

/* user and group databases */
#define PF_PATH		"/etc/passwd"	/* Path name of the "passwd" file */
#define GF_PATH		"/etc/group"	/* Path name of the "group" file */
#endif /* _SYSV_SOURCE */

#ifndef NULL
		#undef NULL
#define	NULL		0
#endif

/* access(..., mode) values */
#define	R_OK		4	/* read permission */
#define	W_OK		2	/* write permission */
#define	X_OK		1	/* execute or serach permission */
#define	F_OK		0	/* existence only */

/* lseek(..., whence) values */
#define	SEEK_SET	0	/* beginning of file */
#define	SEEK_CUR	1	/* current position */
#define	SEEK_END	2	/* end of file */

#ifdef _POSIX_SOURCE
/* initial file descriptor values */
#define	STDIN_FILENO	0
#define	STDOUT_FILENO	1
#define	STDERR_FILENO	2

/* POSIX option flags */
#define	_POSIX_JOB_CONTROL	1
#define	_POSIX_SAVED_IDS	1
#define	_POSIX_VERSION		199009L
#define	_POSIX_CHOWN_RESTRICTED	1
#define	_POSIX_NO_TRUNC		1
#define	_POSIX_VDISABLE		0377

/* sysconf() names */
#define	_SC_ARG_MAX		0x00000001
#define	_SC_CHILD_MAX		0x00000002
#define	_SC_CLK_TCK		0x00000004
#define	_SC_NGROUPS_MAX		0x00000008
#define	_SC_OPEN_MAX		0x00000010
#define	_SC_JOB_CONTROL		0x00000200
#define	_SC_SAVED_IDS		0x00002000
#define	_SC_VERSION		0x00004000
#define	_SC_STREAM_MAX		0x00008000
#define	_SC_TZNAME_MAX		0x00010000

/* pathconf() names */
#define	_PC_LINK_MAX		0x00020000
#define	_PC_MAX_CANON		0x00040000
#define	_PC_MAX_INPUT		0x00080000
#define	_PC_NAME_MAX		0x00100000
#define	_PC_PATH_MAX		0x00200000
#define	_PC_PIPE_BUF		0x00800000
#define	_PC_CHOWN_RESTRICTED	0x01000000
#define	_PC_NO_TRUNC		0x20000000
#define	_PC_VDISABLE		0x80000000

#if !defined(__sys_types_h)
#if defined(__MPW_C__)
# include "/:usr:include:sys:types.h"
#else
# include <sys/types.h>
#endif
#endif /* __sys_types_h */

/* POSIX miscellaneous function declarations */
#if defined(__STDC__)
void _exit(int status);
int access(const char *path, int mode);
unsigned int alarm(unsigned int seconds);
int chdir(const char *path);
int chown(const char *path, uid_t owner, gid_t group);
int close(int fildes);
char *ctermid(char *s);
char *cuserid(char *s);
int dup(int fildes);
int dup2(int fildes, int fildes2);
int execl(const char *path, const char *arg, ...);
int execle(const char *path, const char *arg, ...);
int execlp(const char *file, const char *arg, ...);
int execv(const char *path, char *const argv[]);
int execve(const char *path, char *const argv[], char *const envp[]);
int execvp(const char *file, char *const argv[]);
pid_t fork(void);
long fpathconf(int fildes, int name);
char *getcwd(char *buf, size_t size);
gid_t getegid(void);
uid_t geteuid(void);
gid_t getgid(void);
int getgroups(int gidsetsize, gid_t grouplist[]);
char *getlogin(void);
pid_t getpgrp(void);
pid_t getpid(void);
pid_t getppid(void);
uid_t getuid(void);
int isatty(int fildes);
int link(const char *existing, const char *new);
off_t lseek(int fildes, off_t offset, int whence);
long pathconf(const char *path, int name);
int pause(void);
int pipe(int fildes[2]);
ssize_t read(int fildes, void *buf, size_t nbyte);
int rmdir(const char *path);
int setgid(gid_t gid);
int setpgid(pid_t pid, pid_t pgid);
pid_t setsid(void);
int setuid(uid_t uid);
unsigned int sleep(unsigned int seconds);
long sysconf(int name);
pid_t tcgetpgrp(int fildes);
pid_t tcsetpgrp(int fildes, pid_t pgid);
char *ttyname(int fildes);
int unlink(const char *path);
ssize_t write(int fildes, const void *buf, size_t nbyte);
#else
void _exit();
int access();
unsigned int alarm();
int chdir(), chown();
int close();
char *ctermid(), *cuserid();
int dup(), dup2();
int execl(), execle(), execlp(), execv(), execve(), execvp();
pid_t fork();
long fpathconf();
char *getcwd();
gid_t getegid();
uid_t geteuid();
gid_t getgid();
int getgroups();
char *getlogin();
pid_t getpgrp(), getpid(), getppid();
uid_t getuid();
int isatty(), link();
off_t lseek();
long pathconf();
int pause(), pipe();
ssize_t read();
int rmdir(), setgid(), setpgid(), setsid(), setuid();
unsigned int sleep();
long sysconf();
pid_t tcgetpgrp(), tcsetpgrp();
char *ttyname();
int unlink();
ssize_t write();
#endif /* __STDC__ */

#ifdef _FIPS_151_SOURCE
/* POSIX option flags (artifacts from Draft 12) */
#define	_POSIX_CHOWN_SUP_GRP	1
#define	_POSIX_UTIME_OWNER	1
#define	_POSIX_GROUP_PARENT	1
#define	_POSIX_KILL_SAVED	1
#define	_POSIX_EXIT_SIGHUP	1
#define	_POSIX_KILL_PID_NEG1	1
#define	_POSIX_DIR_DOTS		1
#define	_POSIX_PGID_CLEAR	1
#define	_POSIX_V_DISABLE	_POSIX_VDISABLE

/* sysconf() names (artifacts from Draft 12) */
#define	_SC_PASS_MAX		0x00000020
#define	_SC_PID_MAX		0x00000040
#define	_SC_UID_MAX		0x00000080
#define	_SC_EXIT_SIGHUP		0x00000100
#define	_SC_KILL_PID_NEG1	0x00000400
#define	_SC_KILL_SAVED		0x00000800
#define	_SC_PGID_CLEAR		0x00001000

/* pathconf() names (artifacts from Draft 12) */
#define	_PC_FCHR_MAX		0x00010000
#define	_PC_PIPE_MAX		0x00400000
#define	_PC_CHOWN_SUP_GRP	0x02000000
#define	_PC_DIR_DOTS		0x04000000
#define	_PC_GROUP_PARENT	0x08000000
#define	_PC_LINK_DIR		0x10000000
#define	_PC_UTIME_OWNER		0x40000000
#define	_PC_V_DISABLE		_PC_VDISABLE
#endif /*  _FIPS_151_SOURCE */
#endif /* _POSIX_SOURCE */

#endif /* __unistd_h */
#if defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__)
extern int getopt (int, char *const *, const char *);
#endif /* defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__*/
