#if !defined(__ufs_ufsparam_h)
#define __ufs_ufsparam_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:ufs/ufsparam.h	1.8 92/10/18 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987, 1988, 1989 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1988 UniSoft Corporation */

#ifdef	KERNEL
#if defined(__MPW_C__)
# include "/:usr:include:sys:types.h"
#else
# include "sys/types.h"
#endif
#if defined(__MPW_C__)
# include "/:usr:include:sys:param.h"
#else
# include "sys/param.h"
#endif
#else
#if defined(__MPW_C__)
# include "/:usr:include:sys:types.h"
#else
# include <sys/types.h>
#endif
#if defined(__MPW_C__)
# include "/:usr:include:sys:param.h"
#else
# include <sys/param.h>
#endif
#endif

/*
 * undefine some system V filesystem specific symbols that were set up
 * in param.h
 */
#undef	BBSIZE
#undef	SBSIZE
#undef	BBLOCK
#undef	SBLOCK
#undef	ROOTINO
#undef	MAXBSIZE
#define	MAXBSIZE	8192

/*
 * define some constants and macros provided in param.h on a BSD system
 */

/*
 * Maximum number of fragments in a block (current implementation
 * contrains this to be the number of bits in a byte as tables are
 * used to look up which fragments are free in a block)
 */
#define	MAXFRAG	8

#define	btodb(bytes)	 		/* calculates (bytes / DEV_BSIZE) */ \
	((unsigned)(bytes) >> DEV_BSHIFT)
#define	dbtob(db)			/* calculates (db * DEV_BSIZE) */ \
	((unsigned)(db) << DEV_BSHIFT)

/*
 * Map a ``block device block'' to a file system block.
 * This should be device dependent, and will be after we
 * add an entry to cdevsw for that purpose.  For now though
 * just use DEV_BSIZE.
 */
#define	bdbtofsb(bn)	((bn) / (BLKDEV_IOSIZE/DEV_BSIZE))

/*
 * bit map related macros
 */
#define	setbit(a,i)	((a)[(i)/NBBY] |= 1<<((i)%NBBY))
#define	clrbit(a,i)	((a)[(i)/NBBY] &= ~(1<<((i)%NBBY)))
#define	isset(a,i)	((a)[(i)/NBBY] & (1<<((i)%NBBY)))
#define	isclr(a,i)	(((a)[(i)/NBBY] & (1<<((i)%NBBY))) == 0)

#ifdef	KERNEL
#ifndef CTAGS
/*
 * map some external names to avoid conflict if both 'svfs' and 'ufs'
 * are linked into the same kernel.
 */

/* from fs/ufs/ufs_alloc.c */
#define	alloc		UFS__alloc
#define	ialloc		UFS__ialloc
#define	free		UFS__free
#define	ifree		UFS__ifree
#define	fserr		UFS__fserr

/* from fs/ufs/ufs_bmap.c */
#define	bmap		UFS__bmap
#define	vbmap		UFS__vbmap

/* from fs/ufs/ufs_dir.c */
#define	dirlook		UFS__dirlook
#define	direnter	UFS__direnter
#define	dirremove	UFS__dirremove

/* from fs/ufs/ufs_inode.c */
#define	ifreeh		UFS__ifreeh
#define	ifreet		UFS__ifreet
#define	ihinit		UFS__ihinit
#define	ifind		UFS__ifind
#define	iget		UFS__iget
#define	iput		UFS__iput
#define	irele		UFS__irele
#define	idrop		UFS__idrop
#define	iinactive	UFS__iinactive
#define	iupdat		UFS__iupdat
#define	imark		UFS__imark
#define	itrunc		UFS__itrunc
#define	iflush		UFS__iflush
#define	ilock		UFS__ilock
#define	iunlock		UFS__iunlock
#define	iaccess		UFS__iaccess
#define	iwrtback	UFS__iwrtback
#define	growinotable	UFS__growinotable

/* fs/ufs/ufs_subr.c */
#define	update		UFS__update
#define	syncip		UFS__syncip
#define	badblock	UFS__badblock
#define	getmp		UFS__getmp
#define	isblock		UFS__isblock
#define	clrblock	UFS__clrblock
#define	setblock	UFS__setblock

/* fs/ufs/ufs_vfsops.c */
#define	sbupdate	UFS__sbupdate

/* fs/ufs/ufs_vnodeops.c */
#define	rdwri		UFS__rdwri
#define	rwip		UFS__rwip
#define	chown1		UFS__chown1

/* global variables */
#define	rasize		UFS__rasize
#define	inode		UFS__inode
#define	inodeNINODE	UFS__inodeNINODE
#endif
#endif	/* KERNEL */

#endif /* __ufs_ufsparam_h */
