#if !defined(__sys_scsiccs_h)
#define __sys_scsiccs_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/scsiccs.h	1.9 92/10/16 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

#if !defined(__sys_types_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:types.h"
# else
#   include <sys/types.h>
# endif
#endif 

/*	States for Phases */
/*	Derive state from MSG, CMD, I/O */

#define	SPH_DOUT 0x00	/* Data out phase */
#define	SPH_DIN	 0x01	/* Data in phase */
#define	SPH_CMD	 0x02	/* Command phase */
#define	SPH_STAT 0x03	/* Status phase */
#define	SPH_MOUT 0x06	/* Message out phase */
#define	SPH_MIN	 0x07	/* Message in phase */



/*	Some common SCSI command op codes */

#define	SOP_RDY		0x00	/* test unit ready */
#define	SOP_SENSE	0x03	/* sense error information */
#define	SOP_FMT		0x04	/* format the device */
#define	SOP_REASS	0x07	/* Reassign bad blocks */
#define	SOP_READ	0x08	/* short form group 0 read */
#define	SOP_WRITE	0x0A	/* short form group 0 write */
#define	SOP_INQ		0x12	/* inquiry command */
#define	SOP_SELMODE	0x15	/* set device mode information */
#define SOP_GETMODE	0x1A	/* sense/get mode information */
#define SOP_STARTSTOP	0x1B	/* start/stop unit */
#define SOP_REMOVAL	0x1E	/* prevent/allow medium removal */
#define	SOP_READCAP	0x25	/* read capacity of device */
#define SOP_EJECT	0xC0	/* group6 eject (cdrom) */

/*	Some SCSI message codes */

#define	SMG_COMP	0x00	/* Command complete */
#define	SMG_EXTD	0x01	/* Extend Message */
#define SMG_SAVEP	0x02	/* Save data pointer */
#define SMG_RESTP	0x03	/* Restore data pointer */
#define	SMG_DISC	0x04	/* Disconnect */
#define	SMG_ABT		0x06	/* Abort */
#define	SMG_LNK		0x0A	/* Linked command complete */
#define	SMG_LNKFLG	0x0B	/* Linked command complete (with flag) */
#define	SMG_RESET	0x0C	/* Reset bus device */

/*	Stat Phase bits.
 *	     These define parts of the byte returned by the SCSI target during
 *	the stat phase.
 */

#define	STA_CHK		0x02	/* Issue sense command */
#define STA_BUSY	0x08	/* Unit is busy now */
	
/*	Here is a generic group zero command block.
 */
struct scsig0cmd {
	u_char op;		/* 0: opcode */
	u_char addrH;		/* 1: logical address 2 and LUN */
	u_char addrM;		/* 2: logical address byte 1*/
	u_char addrL;		/* 3: logical address byte 0 */
	u_char len;		/* 4: number of blocks or bytes of other data */
	u_char ctl;		/* 5: control field */
	};
#define	SCIG0LEN 6

struct mode_sel_blks {
	u_char	ms_reserved1;	
	u_char  ms_medium;	/* 00 */
	u_char  ms_reserved2;
	u_char  ms_block;	/* 00 or 08 */
	u_char	ms_reserved3;
	u_char	ms_nb_msb;		/* number of blocks, MSB */
	u_char	ms_nb_isb;		/* number of blocks, ISB */
	u_char	ms_nb_lsb;		/* number of blocks, LSB */
	u_char  ms_reserved4;
	u_char	ms_bl_msb;		/* block length, MSB */
	u_char	ms_bl_isb;		/* block length, ISB */
	u_char	ms_bl_lsb;		/* block length, LSB */
};


#ifdef unrelesed


/*	This file interfaces to Apple SCSI Common Command Set "CCS"
 *	
 */


struct g0t {
	u_char	g0op;
	char   *g0nam;
};

struct g0t g0tab[] = {
	{0x00, "Test Unit Ready"},
	{0x01, "Rezero Unit"},
	{0x03, "Request Sense"},
	{0x08, "Read"},
	{0x0A, "Write"},
	{0x0B, "Seek"},
	{0x12, "Inquiry"},
	{0x15, "Mode Select"},
	{0x16, "Reserve Unit"},
	{0x17, "Release Unit"},
	{0x1A, "Mode Sense"},
	{0x1B, "Start/Stop Unit"},
	{0x1C, "Receive Diagnostic"},
	{0x1D, "Send Diagnostic"},
	{0x1E, "Media Removal"},
	/* g1 */
	{0x25, "Read Capacity"},
	{0x28, "Read Extended"},
	{0x2B, "Seek Extended"},
	{0x2F, "Verify"},
	{0x3B, "Write Buffer"},
	{0x3C, "Read Buffer"},
	/* g6 */
	{0xC0, "Eject Disk"},
	{0xC1, "Read Toc"},
	{0xC2, "Read Q Subcode"},
	{0xC3, "Read Header"},
	{0xC8, "Audio Track Search"},
	{0xC9, "Audio Play"},
	{0xCA, "Audio Pause"},
	{0xCB, "Audio Stop"},
	{0xCC, "Audio Status"},
	{0xCD, "Audio Scan"},
	{0xFF, (char *)0},
};

char *
cmd2str( c0p )
	struct scsig0cmd *c0p;
{
	register struct g0t *gp;
	register i;

	for( i=0, gp = g0tab; gp->g0nam; i++, gp++)
		if ( gp->g0op == c0p->op )
			break;
	return (gp->g0nam) ? gp->g0nam : "?op";
}

struct msgt {
	u_char msg;
	char   *name;
};
struct msgt msgtab[] = {
	0x00, "Command Complete",
	0x01, "Extended Message",
	0x02, "Save Pointers",
	0x03, "Restore Pointers",
	0x04, "Disconnect",
	0x05, "Initiator Err",
	0x06, "Abort",
	0x07, "Message Reject",
	0x08, "No Operation",
	0x09, "Message Parity",
	0x0A, "Linked Cmd Complete",
	0x0B, "Lnkd w/flg Complete",
	0x0C, "Bus Device Reset",
	0x80, "Identify w/o Discon"
	0xC0, "Identify w/ Discon"
	0xFF, (char *)0,
};

char *
msg2str( msg )
	u_char msg;
{
	register struct msgt *gp;
	register i;

	for( i=0, gp = msgtab; gp->name; i++, gp++)
		if ( gp->msg == msg )
			break;
	return (gp->name) ? gp->name : "?msg";
}

char *stattab[16] = {
	"Good",			/*  0 */
	"Check Condition",	/*  1 */
	"Condit Met/Good",	/*  2 */
	"reserved",
	"Busy",			/*  4 */
	"reserved",
	"reserved",
	"reserved",
	"Intermediate/Good",	/*  8 */
	"reserved",
	"Inter Met/Good",	/* 10 */
	"reserved",
	"Reservation Conflict",	/* 12 */
	"reserved",
	"reserved",
	"reserved",
};
	
char *
stat2str( stat)
	u_char stat;
{
	register i;

	return stattab[ 0xF & (stat >> 1) ];
}

/*
 *
 *	ccs00( rp,id,lun, vu)			Test Unit Ready
 *	ccs03( rp,id,lun, len, vu)		Request Sense
 *	ccs12( rp,id,lun, len, vu)		Inquiry
 *	ccs1C( rp,id,lun, len, vu)	Receive Diagnostic Results
 *	ccs1D( rp,id,lun,			Send Diagnostic Result
 *		selfTest, devOfl, unitOfl,
 *		al2, al1, vu)
 *
 *	group0 direct access devices
 *
 *	ccs01( rp,id,lun, vu)			Rezero Unit
 *	ccs04( rp,id,lu,			Format Unit
 *		fmtData, cmpLst, defctLsFmt,
 *		vu1, intrlv, vu2)
 *	ccs07( rp,id,lun, vu)			Reassign Blocks
 *	ccs08( rp,id,lun, lbn21, nb8, vu)		Read
 *	ccs0A( rp,id,lun, lbn21, nb8, vu)		Write
 *	ccs0B( rp,id,lun, lbn21, vu)		Seek
 *	ccs15( rp,id,lun, len, vu)		Mode Select
 *	ccs16( rp,id,lun,			Reserve
 *		thrdPrty, thid, ext,
 *		resIdent, extl, vu)
 *	ccs17( rp,id,lun,			Release
 *		thrdPrty, thid, ext,
 *		resIdent, extl, vu)
 *	ccs1A( rp,id,lun, len, vu)		Mode Sense
 *	ccs1B( rp,id,lun, immed, start, vu)	Start/Stop Unit
 *	ccs1E( rp,id,lun, prevent, vu)		Prevent/Allow Med. Remov
 *
 *	group 1 for direct-access devices
 *	ccs24( rp,id,lun, relA, lbn,		Read Capacity
 *		vu1, pmi, vu2)
 *	ccs28( rp,id,lun, lbn32, nb16, vu)	Read
 *	ccs2A( rp,id,lun, lbn32, nb16, vu)	Write
 *	ccs2B( rp,id,lun, lbn32, vu)		Seek
 *	ccs2E( rp,id,lun, lbn32, nbl16, vu)	Write and Verify
 *	ccs2F( rp,id,lun, lbn32, nbl16, vu)	Verify
 *
 *	Search Data
 *	ccs30( rp,id,lun, invrt,		Search Data High
 *		spndat, reladr,
 *		lbn32, nb16, vu)
 *	ccs31( rp,id,lun, invrt,		Search Data Equal
 *		spndat, reladr,
 *		lbn32, nb16, vu)
 *	ccs30( rp,id,lun, invrt,		Search Data Low
 *		spndat, reladr,
 *		lbn32, nb16, vu)
 *	ccs33( rp,id,lun, rdInh, wrInh,		Set Limits
 *		lbn, nb, vu)
 *
 *	group0 for sequential access
 *
 *	ccs01( rp,id,lun, immed, vu)		Rewind
 *	ccs05( rp,id,lun, vu)			Read Block Limits
 *	ccs08( rp,id,lun, fxd, len24, vu)	Read
 *	ccs0A( rp,id,lun, fxd, len24, vu)	Write
 *	ccs0B( rp,id,lun, trk8, vu2)		Track Select
 *	ccs0F( rp,id,lun, fxd, len24, vu2)	Read Reverse
 *	ccs10( rp,id,lun, nmrk24, vu2)		Write Filemarks
 *	ccs11( rp,id,lun, cod2, cnt24, vu2)	Space
 *	ccs13( rp,id,lun, bytcmp, fxd,		Verify
 *		len24, vu2)		
 *	ccs14( rp,id,lun, fxd, len24, vu2)	Recover Buffer Data
 *	ccs15( rp,id,lun, len8, vu2)		Mode Select
 *	ccs16( rp,id,lun, thrdpty,      	Reserve Unit
 *		thid2, vu2)	
 *	ccs17( rp,id,lun, thrdpty,      	Release Unit
 *		thid2, vu2)	
 *	ccs19( rp,id,lun, long, vu2)		Erase
 *	ccs1A( rp,id,lun, len8, vu2)		Mode Sense
 *	ccs1B( rp,id,lun, immed,		Load/Unload
 *		reten, load, vu2)
 *	ccs1E( rp,id,lun, prevent, vu2)		Prevent/Allow Med Remov 
 *
 *	group0 printer
 *
 *	ccs04( rp,id,lun, fmt2, len24, vu2)	Format
 *	ccs0A( rp,id,lun, len24, vu2)		Print
 *	ccs0B( rp,id,lun, chan, slew8,		Slew and Print
 *		len16, vu2)
 *	ccs10( rp,id,lun, vu2)			Flush Buffer
 *	ccs14( rp,id,lun, len24, vu2)		Recover Buffer Data
 *	ccs15( rp,id,lun, len8, vu2)		Mode Select
 *
 *	group0 for processor devices
 *
 *	ccs08( rp,id,lun, len24, vu2)		Receive
 *	ccs0A( rp,id,lun, len24, vu2)		Send
 */

		
#endif

#endif /* __sys_scsiccs_h */
