#if !defined(__sys_region_h)
#define __sys_region_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/region.h	2.8 92/07/23 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1984-85 AT&T */

#if !defined(__sys_page_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:page.h"
# else
#   include <sys/page.h>
# endif
#endif 

/*
 * Per region descriptor.  One is allocated for every active region in
 *  the system.  Records the size of the page table and a list of pointers
 *  to page tables for this region.
 * At most one page is allocated for this list, limiting a region to 256MB.
 * The associated page table is a tree, allocated as a collection of 512-byte
 *  blocks of pte's.  The lowest level of the tree is actually a 256-byte page
 *  table block followed by a 256-byte "shadow table" of dbd's (see page.h)
 */

typedef	struct	region	{
	short	r_flags;	/* Various flags defined below. */
	short	r_plistsz;	/* Number of chunks in r_plist	*/
	int	r_ptcount;	/* Number of valid pt pointers in r_plist*/
	u_long	r_pgsz;		/* size in pages */
	short	r_stack;	/* flag for stack region */
	u_long	r_nvalid;	/* number of valid pages in region */
	short	r_refcnt;	/* number of users pointing at region */
	short	r_type;		/* type of region */
	short	r_noswapcnt;	/* Count of nbr of processes which have	*/
				/* requested that this region not be	*/
				/* swapped out.				*/
	int	r_filesz;	/* Size in bytes of section of file	*/
				/* from which this region is loaded.	*/
	pte_t	**r_plist;	/* Pointer to a list of pointers to	*/
				/* page tables and dbd's.		*/
	int	r_lock;		/* Lock */
	struct vnode   *r_vptr;	/* pointer to inode where blocks are */
	struct region  *r_forw;	/* forward link */
	struct region  *r_back;	/* backward link */
} reg_t;

/*
 * Region flags
 */
#define	RG_NOFREE	0x0002	/* Don't free region on last detach */
#define	RG_DONE		0x0004	/* Region is initialized */
#define	RG_NOSHARE	0x0008	/* Don't share the region. */
#define RG_WAITING	0x0010	/* Someone is waiting on RG_DONE */

/*
 * Region types
 */
#define	RT_UNUSED	0	/* Region not being used.	*/
#define	RT_PRIVATE	1	/* Private (non-shared) region. */
#define RT_STEXT	2	/* Shared text region */
#define RT_SHMEM	3	/* Shared memory region */
#define	RT_PHYSCALL	0x8000		/* Uniplus+ phys call region.	*/

/*	Each process has a number of pregions which describe the
 *	regions which are attached to the process.
 */

typedef struct pregion {
	struct region	*p_reg;		/* Pointer to the region.	*/
	caddr_t		p_regva;	/* User virtual address of	*/
					/* region.			*/
	short		p_flags;	/* Flags.			*/
	short		p_type;		/* Type.			*/
} preg_t;

/*	Pregion flags.
 */
#define	PF_RDONLY	0x0001		/* Read-only attach.		*/
#define PF_MAC24	0x0002		/* 24-bit version of a 24-bit proc */
#define PF_MAC32	0x0004		/* 32-bit version of a 24-bit proc */

/*	Pregion types.
 */

#define	PT_UNUSED	0x00		/* Unused region.		*/
#define	PT_TEXT		0x01		/* Text region.			*/
#define	PT_DATA		0x02		/* Data region.			*/
#define	PT_STACK	0x03		/* Stack region.		*/
#define	PT_SHMEM	0x04		/* Shared memory region.	*/
#define PT_LIBTXT	0x05		/* Shared library text region	*/
#define PT_LIBDATA	0x06		/* Shared library data region	*/
#define	PT_PHYSCALL	0x8000		/* Uniplus+ phys call region.	*/

extern preg_t	nullpregion;		/* A null preg_t. */
extern int	pregpp;			/* Number of pregions per	*/
					/* process including null one.	*/

#if defined(KERNEL)
# if defined(AUTOCONFIG)
    extern reg_t *region;		/* Global array of regions */
# else
    extern reg_t region[];		/* Global array of regions */
# endif
#endif /* KERNEL */

extern reg_t	ractive;	/* List of active regions */
extern reg_t	rfree;		/* List of free regions */
extern reg_t	sysreg;		/* System region. */
/* extern reg_t	nullregion;	/* A null region. */

reg_t		*allocreg();	/* region allocator */
void		freereg();	/* region free routine */
preg_t		*attachreg();	/* Attach region to process. */
void		detachreg();	/* Detach region from process. */
reg_t		*dupreg();	/* Duplicate region (fork). */
int		growreg();	/* Grow region. */
int		loadreg();	/* Load region from file. */
int		mapreg();	/* Map region to 413 file. */
reg_t		*findreg();	/* Find region from virtual address. */
preg_t		*findpreg();	/* Find pregion of given type. */
preg_t		*vtopreg();	/* Find pregion from virtual address. */
void		chgprot();	/* Change protection for region. */
void		reginit();	/* Initialize the region table. */

#endif /* __sys_region_h */
