#if !defined(__sys_param_h)
#define __sys_param_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/param.h	2.22 93/10/26 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1984-85 AT&T */

/*
 * Machine dependent constants
 */

#define BPWSHFT		2	/* Shift for nbr of bytes per word. */
#define BPDSHFT		9	/* Shift for bytes per disk block. */
#define DOFFMASK	0x1FF	/* Mask for offset into disk block. */

#define MSWAPX		15	/* pseudo mount table index for swapdev */
#define	USIZE		1	/* size of user block in pages. */
#define LOCSIZE		1	/* size of local data area in pages */
#define	COPYSEGSZ	2	/* Size of copyseg in pages.	*/

#define	HZ		60	/* Ticks/second of the clock */

/*
 * fundamental variables
 * don't change
 */

#define ONOFILE  32
#define NOFILE	128		/* max open files per process */
#define	MAXPID	30000		/* max process id */
#define	MAXUID	65534		/* max user id */
#define	MAXLINK	32767		/* max links */

#define	NGROUPS	8		/* max number groups */
#define	NOGROUP	-1		/* marker for empty group set member */

#define	CANBSIZ	256		/* max size of typewriter line	*/
#define	NCARGS	20480		/* # characters in exec arglist */
#define PIPSIZ	(8192)		/* should not exceed number of bytes that */
				/* can be mapped directly by filesystem */
#define MAXHOSTNAMELEN	32

#define	SSIZE	1		/* initial stack size (in clicks) */
#define	SINCR	1		/* increment of stack (in clicks) */

#define PVFS	27
#define	PLOCK	35
/*
 * priorities
 */

#define	PMASK	00177
#define	PCATCH	00400
#define PINTR   01000

#define	PSWP	0
#define	PMEM	0
#define	PINOD	10
#define	PRIBIO	20
#define	PZERO	25
#define	PDELAY	(PZERO-1)
#define	NZERO	20
#define	PPIPE	26
#define	PWAIT	30
#define	PSLEP	39
#define	PUSER	60
#define	PIDLE	127
#define	PMAX	127

/*
 * Signals
 */
#ifdef KERNEL
#if defined(__MPW_C__)
# include "/:usr:include:signal.h"
#else
# include "signal.h"
#endif
#else
#if defined(__MPW_C__)
# include "/:usr:include:signal.h"
#else
# include <signal.h>
#endif
#endif

#define ISSIG(p) \
	((p)->p_sig && ((p)->p_flag&STRC || \
	 ((p)->p_sig &~ ((p)->p_sigignore | (p)->p_sigmask))) && issig())

/*
 * fundamental constants of the implementation
 */

#define	NBPW	sizeof(int)	/* number of bytes in an integer */
#define NBBY	8		/* number of bits in a byte */

		#undef NULL
#define	NULL	0

#define	MAXBSIZE	8192
#define	SBUFSIZE	4096
#define	DEV_BSIZE	512
#define	DEV_BSHIFT	9		/* log2(DEV_BSIZE) */
#define	DEV_BMASK	(DEV_BSIZE-1)
#define BLKDEV_IOSIZE	MAXBSIZE

#define	MAXNAMLEN	255
#define MAXPATHLEN	1024
#define MAXSYMLINKS	8

#define	CMASK	0		/* default mask for file creation */
#define	CDLIMIT	(1L<<24)	/* default max write address */
#define	NODEV	(dev_t)(-1)
#define	ROOTINO	((ino_t)2)	/* i number of all roots */
#define	NICINOD	100		/* number of superblock inodes */

#ifndef	FsTYPE
#define	FsTYPE	3
#endif

#if FsTYPE==1
	/* Original 512 byte file system */
#define	BSIZE	512		/* size of file system block (bytes) */
#define	BSHIFT	9		/* LOG2(BSIZE) */
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#define	BMASK	0777		/* BSIZE-1 */
#define	INOPB	8		/* inodes per block */
#define	INOSHIFT	3	/* LOG2(INOPB) if exact */
#define	NMASK	0177		/* NINDIR-1 */
#define	NSHIFT	7		/* LOG2(NINDIR) */

#define	FsBSIZE(fsp)	BSIZE
#define	FsBSHIFT(fsp)	BSHIFT
#define	FsNINDIR(fsp)	NINDIR
#define	FsBMASK(fsp)	BMASK
#define	FsBOFF(fsp, x)	((x)&BMASK)
#define	FsBNO(fsp, x)	((u_int)(x)>>BSHIFT)
#define	FsINOPB(fsp)	INOPB
#define	FsLTOP(fsp, b)	b
#define	FsPTOL(fsp, b)	b
#define	FsNMASK(fsp)	NMASK
#define	FsNSHIFT(fsp)	NSHIFT
#define	FsITOD(fsp, x)	(((unsigned)(x)+(2*8-1))>>3)
#define	FsITOO(fsp, x)	(((unsigned)(x)+(2*8-1))&07)
#define	FsINOS(fsp, x)	(((x)&~07)+1)
#endif

#if FsTYPE==2
	/* New 1024 byte file system */
#define	BSIZE	1024		/* size of file system block (bytes) */
#define	BSHIFT	10		/* LOG2(BSIZE) */
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#define	BMASK	01777		/* BSIZE-1 */
#define	INOPB	16		/* inodes per block */
#define	INOSHIFT	4	/* LOG2(INOPB) if exact */
#define	NMASK	0377		/* NINDIR-1 */
#define	NSHIFT	8		/* LOG2(NINDIR) */
#define	FsBSIZE(fsp)	BSIZE
#define	FsBSHIFT(fsp)	BSHIFT
#define	FsNINDIR(fsp)	NINDIR
#define	FsBMASK(fsp)	BMASK
#define	FsBOFF(fsp, x)	((x)&BMASK)
#define	FsBNO(fsp, x)	((u_int)(x)>>BSHIFT)
#define	FsINOPB(fsp)	INOPB
#define	FsLTOP(fsp, b)	((b)<<1)
#define	FsPTOL(fsp, b)	((u_int)(b)>>1)
#define	FsNMASK(fsp)	NMASK
#define	FsNSHIFT(fsp)	NSHIFT
#define	FsITOD(fsp, x)	(((unsigned)(x)+(2*16-1))>>4)
#define	FsITOO(fsp, x)	(((unsigned)(x)+(2*16-1))&017)
#define	FsINOS(fsp, x)	((((x)&~017)+1))
#endif

#if FsTYPE==3
#define	FsLRG(fsp)	((fsp)->s_type == Fs2b)
#define	FsBSIZE(fsp)	(FsLRG(fsp) ? 1024 : 512)
#define	FsBSHIFT(fsp)	(FsLRG(fsp) ? 10 : 9)
#define	FsNINDIR(fsp)	(FsLRG(fsp) ? 256 : 128)
#define	FsBMASK(fsp)	(FsLRG(fsp) ? 01777 : 0777)
#define	FsBOFF(fsp, x)	(FsLRG(fsp) ? ((x)&01777) : ((x)&0777))
#define	FsBNO(fsp, x)	(FsLRG(fsp) ? ((u_int)(x)>>10) : ((u_int)(x)>>9))
#define	FsINOPB(fsp)	(FsLRG(fsp) ? 16 : 8)
#define	FsLTOP(fsp, b)	(FsLRG(fsp) ? (b)<<1 : b)
#define	FsPTOL(fsp, b)	(FsLRG(fsp) ? (u_int)(b)>>1 : b)
#define	FsNMASK(fsp)	(FsLRG(fsp) ? 0377 : 0177)
#define	FsNSHIFT(fsp)	(FsLRG(fsp) ? 8 : 7)
#define	FsITOD(fsp, x)	(daddr_t)(FsLRG(fsp) ? \
	((unsigned)(x)+(2*16-1))>>4 : ((unsigned)(x)+(2*8-1))>>3)
#define	FsITOO(fsp, x)	(daddr_t)(FsLRG(fsp) ? \
	((unsigned)(x)+(2*16-1))&017 : ((unsigned)(x)+(2*8-1))&07)
#define	FsINOS(fsp, x)	(FsLRG(fsp) ? \
	(((x)&~017)+1) : (((x)&~07)+1))
#endif

#if FsTYPE==7
	/* 512, 1024, and 2048 bytes per block system */
#define	FsLRG(fsp)	((fsp)->s_type == Fs2b)
#define	FsXLRG(fsp)	((fsp)->s_type == Fs4b)
#define	FsBSIZE(fsp)	(FsXLRG(fsp) ? (DEV_BSIZE*4) : \
	(FsLRG(fsp) ? (DEV_BSIZE*2) : DEV_BSIZE))
#define	FsBSHIFT(fsp)	(FsXLRG(fsp) ? 11 : ((FsLRG(fsp) ? 10 : 9)))
#define	FsNINDIR(fsp)	(FsXLRG(fsp) ? 512 : ((FsLRG(fsp) ? 256 : 128)))
#define	FsBMASK(fsp)	(FsXLRG(fsp) ? 03777 : ((FsLRG(fsp) ? 01777 : 0777)))
#define	FsBOFF(fsp, x)	(FsXLRG(fsp) ? ((x)&03777) : \
	(FsLRG(fsp) ? ((x)&01777) : ((x)&0777)))
#define	FsBNO(fsp, x)	(FsXLRG(fsp) ? ((u_int)(x)>>11) : \
	(FsLRG(fsp) ? ((u_int)(x)>>10) : ((u_int)(x)>>9)))
#define	FsINOPB(fsp)	(FsXLRG(fsp) ? 32 : (FsLRG(fsp) ? 16 : 8))
#define	FsLTOP(fsp, b)	(FsXLRG(fsp) ? (b)<<2 : (FsLRG(fsp) ? (b)<<1 : b))
#define	FsPTOL(fsp, b)	(FsXLRG(fsp) ? (u_int)(b)>>2 : (FsLRG(fsp) ? (u_int)(b)>>1 : b))
#define	FsNMASK(fsp)	(FsXLRG(fsp) ? 0777 : (FsLRG(fsp) ? 0377 : 0177))
#define	FsNSHIFT(fsp)	(FsXLRG(fsp) ? 9 : (FsLRG(fsp) ? 8 : 7))
#define	FsITOD(fsp, x)	(daddr_t)(FsXLRG(fsp) ? ((unsigned)(x)+(2*32-1))>>5 : \
	(FsLRG(fsp) ? ((unsigned)(x)+(2*16-1))>>4 : ((unsigned)(x)+(2*8-1))>>3))
#define	FsITOO(fsp, x)	(daddr_t)(FsXLRG(fsp) ? ((unsigned)(x)+(2*32-1))&037 : \
	(FsLRG(fsp) ? ((unsigned)(x)+(2*16-1))&017 : ((unsigned)(x)+(2*8-1))&07))
#define	FsINOS(fsp, x)	(FsXLRG(fsp) ? (((x)&~037)+1) : \
	(FsLRG(fsp) ? (((x)&~017)+1) : (((x)&~07)+1)))
#endif

#if FsTYPE==11
	/* 512, 1024 and 4096 bytes per block system */
#define	FsLRG(fsp)	((fsp)->s_type == Fs2b)
#define	FsXXLRG(fsp)	((fsp)->s_type == Fs8b)
#define	FsBSIZE(fsp)	(FsXXLRG(fsp) ? (DEV_BSIZE*8) : \
			(FsLRG(fsp) ? (DEV_BSIZE*2) : DEV_BSIZE))
#define	FsBSHIFT(fsp)	(FsXXLRG(fsp) ? 12 : \
			(FsLRG(fsp) ? 10 : 9))
#define	FsNINDIR(fsp)	(FsXXLRG(fsp) ? 1024 : \
			(FsLRG(fsp) ? 256 : 128))
#define	FsBMASK(fsp)	(FsXXLRG(fsp) ? 07777 : \
			(FsLRG(fsp) ? 01777 : 0777))
#define	FsBOFF(fsp, x)	(FsXXLRG(fsp) ? ((x)&07777)  : \
			(FsLRG(fsp) ? ((x)&01777) : ((x)&0777)))
#define	FsBNO(fsp, x)	(FsXXLRG(fsp) ? ((u_int)(x)>>12) : \
			(FsLRG(fsp) ? ((u_int)(x)>>10) : ((u_int)(x)>>9)))
#define	FsINOPB(fsp)	(FsXXLRG(fsp) ? 64 : \
			(FsLRG(fsp) ? 16 : 8))
#define	FsLTOP(fsp, b)	(FsXXLRG(fsp) ? (b)<<3 : \
			(FsLRG(fsp) ? (b)<<1 : b))
#define	FsPTOL(fsp, b)	(FsXXLRG(fsp) ? (u_int)(b)>>3 : \
			(FsLRG(fsp) ? (u_int)(b)>>1 : b))
#define	FsNMASK(fsp)	(FsXXLRG(fsp) ? 01777 : \
			(FsLRG(fsp) ? 0377 : 0177))
#define	FsNSHIFT(fsp)	(FsXXLRG(fsp) ? 10 : \
			(FsLRG(fsp) ? 8 : 7))
#define	FsITOD(fsp, x)	(daddr_t) \
			(FsXXLRG(fsp) ? ((unsigned)(x)+(2*64-1))>>6 : \
			(FsLRG(fsp) ? ((unsigned)(x)+(2*16-1))>>4 : \
			((unsigned)(x)+(2*8-1))>>3))
#define	FsITOO(fsp, x)	(daddr_t) \
			(FsXXLRG(fsp) ? ((unsigned)x+(2*64-1))&077 : \
			(FsLRG(fsp) ? ((unsigned)x+(2*16-1))&017 : \
			((unsigned)x+(2*8-1))&07))
#define	FsINOS(fsp, x)	(FsXXLRG(fsp) ? ((x&~077)+1) : \
			(FsLRG(fsp) ? ((x&~017)+1) : ((x&~07)+1)))
#endif

#define	FsBLKOFF(fsp,b)	((b) & FsBMASK(fsp))

#define	BBLOCK		((daddr_t)(0))
#define BBSIZE		(DEV_BSIZE)
#define	SBLOCK		((daddr_t)(BBLOCK + BBSIZE / DEV_BSIZE))
#define SBSIZE		(DEV_BSIZE)
/* added for compatibility with old utilities */
#define SUPERB		SBLOCK
#define SUPERBOFF	(SBLOCK * DEV_BSIZE)

#define	NICFREE	50		/* number of superblock free blocks */
#define	SUPBSIZE	512	/* number of bytes in the superblock */

#define MEMIOPTE	LOCSIZE
#define MEMIOSIZE	1
#define PHYSIOPTE	(MEMIOPTE+MEMIOSIZE)

#ifdef BARRACUDA
#define	PHYSIOSIZE	32	/* size of physio block in pages. */
#else
#define	PHYSIOSIZE	8	/* size of physio block in pages. */
#endif

#define MAXMEM	(btop(v.v_uend-v.v_ustart))/* Maximum size of user program */
#define MAXBLK	20		/* max blocks possible for physical I/O */
#define USTART	0x0		/* logical start of user program */
#define UEND	(ADDRMASK+1)	/* logical end of user program +1 */

#define UDOT	0x12FFF000	/* Logical base of udot area */

#define	CLKTICK	16667		/* microseconds in a clock tick */
#define	NPHYS	24		/* max simultaneous phys() calls */
#define STKMAGIC 0xA55A5AA5	/* stack verification size magic number */

#define	NSCATLOAD 0		/* number of scatter load segments */
#define DOFFSET	0		/* Data offset */
#define KVOFFSET 0		/* Kernel virtual offset from physical 0 mem */
#define TXTRND 0x400000		/* Shared text rounding factor of 4Meg */

#define	CPUPRI(ps)	((ps) & PS_IPL)		/* Mask for CPU priority bits */
#define	BASEPRI(ps)	(CPUPRI(ps) != 0)	/* CPU base priority */

#define	lobyte(X)	(((unsigned char *)&(X))[1])
#define	hibyte(X)	(((unsigned char *)&(X))[0])
#define	loword(X)	(((ushort *)&(X))[1])
#define	hiword(X)	(((ushort *)&(X))[0])

#ifndef MIN
#define MIN(a,b)	(((a) < (b))?(a):(b))
#endif
#ifndef MAX
#define MAX(a,b)	(((a) > (b))?(a):(b))
#endif
#ifdef KERNEL
#define min(a,b)	MIN(a,b)		/* was in math.s for 3B20 */
#define bcopy(a,b,c)	blt(b, a, c)
#endif
/*
 * Macros for counting and rounding.
 */
#define howmany(x, y)	(((x)+((y)-1))/(y))
#define roundup(x, y)	((((x)+((y)-1))/(y))*(y))

	/* macros to eliminate sep I/D */
#define fuiword(x)	fuword(x)
#define suiword(x,y)	suword(x,y)

#define SPL0()		asm("	mov.w	&0x2000,%sr")
#define SPL1()		asm("	mov.w	&0x2100,%sr")
#define SPL2()		asm("	mov.w	&0x2200,%sr")
#define SPL3()		asm("	mov.w	&0x2300,%sr")
#define SPL4()		asm("	mov.w	&0x2400,%sr")
#define SPL5()		asm("	mov.w	&0x2500,%sr")
#define SPL6()		asm("	mov.w	&0x2600,%sr")
#define SPL7()		asm("	mov.w	&0x2700,%sr")

#define splclk(x)	spl6(x)
#define spltty(x)	spl5(x)
#define SPLHI()		SPL7()
#define SPLCLK()	SPL6()
#define SPLTTY()	SPL5()

/*
 * POSIX-defined magic input character cookie
 */
#define	_POSIX_VDISABLE		0377
#ifdef __STDC__
#if !defined(NOINLINE) && !defined(__GNUC__)

__asm int
__spl_inline(int ipri)
{
%con ipri
    mov.w	%sr,%d0
    mov.w	ipri,%sr
}
#define spl7()		__spl_inline(0x2700)	/* set priority 7 */
#define splhi()		spl7()
#define spl6()		__spl_inline(0x2600)	/* set priority 6 */
#define splclock()	spl6()
#define splimp()	spl6()
#define splclock()	spl6()
#define spl5()		__spl_inline(0x2500)	/* set priority 5 */
#define spl4()		__spl_inline(0x2400)	/* set priority 4 */
#define spl3()		__spl_inline(0x2300)	/* set priority 3 */
#define spl2()		__spl_inline(0x2200)	/* set priority 2 */
#define spl1()		__spl_inline(0x2100)	/* set priority 1 */
#define spl0()		__spl_inline(0x2000)	/* set priority 0 */

__asm void
splx(int ipri)
{
%reg ipri
    mov.w	ipri,%sr
%mem ipri
    mov.l	ipri,%d0
    mov.w	%d0,%sr
}

#endif /* !NOINLINE */
#endif /* __STDC__ */


#endif /* __sys_param_h */
