#if !defined(__sys_page_h)
#define __sys_page_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/page.h	2.8 91/07/10 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1985-87 UniSoft Corporation */

#if !defined(__sys_types_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:types.h"
# else
#   include <sys/types.h>
# endif
#endif 

#if !defined(__sys_mmu_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:mmu.h"
# else
#   include <sys/mmu.h>
# endif
#endif 

/*
 *	Page-related constants.
 */

#ifndef LOCORE		/* to help the assembler */
#define	NBPP		PAGESIZE		/* bytes per page	*/
#endif
#define	BPPSHFT		PAGESHIFT		/* LOG2(NBPP) if exact	*/
#define DPPSHFT		(PAGESHIFT-BPDSHFT)	/* disk blocks per page	*/
#define NDPP		(1<<DPPSHFT)		/* disk blocks per page	*/
#define NPGPTSHFT	PTBLINDEX		/* NPGPT		*/
#define NPGPT		(1<<NPGPTSHFT)		/* pages per page table	*/
#define NPPGPTSHFT	PPTBLINDEX		/* NPPGPT		*/
#define NPPGPT		(1<<NPPGPTSHFT)		/* phys pg per page table*/
#define PT_NSWAP_SZ	256			/* PT Size with no dbd's */
#define NPTPPG		(PAGESIZE/PT_NSWAP_SZ)	/* # tables in a page	*/
/* # pt pointers in a chunk of region plist */
#define NPTPBLK		(PT_NSWAP_SZ/sizeof (pte_t *))

/*
 * We may need to translate between physical and logical pages,
 *  although for A/UX, there is currently no difference.
 */
#define	PPTOPSHFT	(PPTBLINDEX-PTBLINDEX)
#define pptop(x)	((u_int)(x) >> PPTOPSHFT) 
#define ptopp(x)	((x) << PPTOPSHFT) 
#define POFFMASK	(PAGESIZE-1)	    /* Offset into page		 */
#define PPOFFMASK	(PPAGESIZE-1)	    /* Offset into phys page	 */
#define PAGE_ALIGN(x)	( ( (long)(x) + POFFMASK) & ~POFFMASK)
/* Page frame number after shift */
#define PGFNMASK	((1<<(PTBLINDEX+L2INDEX+L1INDEX))-1)

/* This assumes the pte is 4 bytes long, which is true for the PMMU. */
#define	PTSZSHFT	(PPTBLINDEX+2)
#define PTSIZE		(1<<PTSZSHFT)
#define	NPTPPSHFT	(PAGESHIFT-PTSZSHFT)/* Shift to get NPTPP	 */
#define	NPTPP		(1<<NPTPPSHFT)	    /* Page tables per page	 */

/*
 * Round up page table address - 040 requires 512-byte boundar
 */
#define PTBOUND	512
#define ptround(p)	((int *) (((int)(p) + PTBOUND-1) & ~(PTBOUND-1)))

/* Round down page table address */
#define ptalign(p)	((int *) ((int)(p) & ~(PTSIZE-1)))

/* Page Table */
#ifndef LOCORE			/* To help the assembler */
typedef union ptbl {
	int page[NPPGPT];
} ptbl_t;
#endif

/*
 * Page Macros
 */

/* Get page number from system virtual address.	 */
#define	svtop(X)	(((u_int)(X) >> PAGESHIFT) & PGFNMASK)

/* Get system virtual address from page number.	 */
#define	ptosv(X)	((int)(X) << PAGESHIFT)

/* Get page table entry for a system virtual page.	 */
#define	ptopte(X)	(&Pt_pte(K_L1tbl, ((X)<<PAGESHIFT)))

/* Get the physical address corresponding to a system virtual address */
#define svirtophys(X)	realvtop(FCSUPVD, X)

/* Get the pfdat corresponding to a system virtual address */
#define svtopfd(X)	((pfd_t *) (pftopfd(btotp(svirtophys(X)))))
#define btopfd(X)	((pfd_t *) (pftopfd(btotp(svirtophys(X)))))

#ifndef LOCORE			/* To help the assembler */
caddr_t realsvtop();

extern struct pfdat *pftopfd();
extern int pfdtopf();
extern int		nptalloced;

/*
 *  Page setup to match either 020 (851), 030, or 040
 *   Note that only the UR bit (11) can be guaranteed to be available for
 *   software; as a result, we will make the following choice:
 *	   UR == CW (copy on write)
 *  The other SW bits are in free space in the dbd, which shadows the page
 *   table (note that only the lowest level, "true", page tables are shadowed,
 *   so that upper level tables will not be swapped/paged).
 *					    12 11		     1 0
 *   --------------------------------------------------------------------
 *   |		     page address	      |UR|		     |DT|
 *   --------------------------------------------------------------------
 *		       19(8K) - 20(4K)
 */

#if (PAGESIZE == 4096)
#define PG_ADDR		0xFFFFF000	/* physical page address */
#define	PGADDRSHFT	12		/* pfn to position in pte */
#define PAGE_DEF	pg_pfn	: 20
#endif

#if (PAGESIZE == 8192)
#define PG_ADDR		0xFFFFE000	/* physical page address */
#define	PGADDRSHFT	13		/* pfn to position in pte */
#define PAGE_DEF	pg_pfn	: 19, pg_xxx1	: 1
#endif

/*
 * Set up to work with 020 (851), 030, 040.  In each case, some bits
 *  are ignored (xx2, lower cm bit for 020, 030).  GS is not used on any,
 *  but may be used on 040 (only supporting chip).
 */
typedef union pte {
	struct {		 /* For 68851 */
		unsigned long
			PAGE_DEF,	/* Page bits + dummy bits	*/
			pg_cw	: 1,	/* Copy on write.	   (SW) */
			pg_gs	: 1,	/* Globally shared (020, 030)	*/
			pg_xx2	: 3,	/* Dummy bits			*/
			pg_cm	: 2,	/* Cache mode (inhibit on 020)	*/
			pg_mod	: 1,	/* Page has been modified flag.	*/
			pg_ref	: 1,	/* Page has been referenced.	*/
			pg_prot	: 1,	/* Write protect.		*/
			pg_v	: 2;	/* Descriptor type (valid bit).	*/
	} pgm;
	/* 
	 * For fast mask operations when needed
	 */
	struct {
		long	pg_pte;
	} pgi;
} pte_t;
typedef pte_t	ppte_t;
extern pte_t *Pt_ptr();
extern pte_t *Pt_ent();
extern caddr_t Pg_ptr();
#endif

/* Page Table Entry */
#define PG_COPYW	0x00000800	/* copy on write bit (software) */
#define PG_SG		0x00000080	/* Shared Global Descr (020) */
#define PG_CI		0x00000040	/* cache inhibit bit */
#define PG_CWT		0x00000000	/* cacheable, write through */
#define PG_CCB		0x00000020	/* cacheable, copy back */
#define PG_CM		0x00000060	/* cache mode mask (040) */
#define PG_M		0x00000010	/* modified bit (page written to) */
#define PG_REF		0x00000008	/* reference bit (page accessed)*/
#define PG_PROT		0x00000004	/* CPU protection field */
#define PG_PERM		0x00000004	/* write protect bit (supv or user) */
#define PG_VFIELD	0x00000003	/* page descriptor field */

/*
 * The "valid" bit is really the low bit in the DT field, but high bit is
 * zero for real pte's.
 */
#define	PG_V		0x00000001	/* page valid bit */

/* There is only one protection bit in a short (32-bit) page descriptor.
 * PG_NOACC actually allows reading, just not writing.	There is no
 * distinction between supervisor and user accesses at this level. */
#define	PG_NOACC	0x00000004	/* "no" permission */
#define PG_ALL		0x00000000	/* all permissions */
#define PG_RO		PG_NOACC
#define PG_RW		PG_ALL
#define PG_WRT		PG_ALL

/*
 * These two software bits refer to pages, but are located in the shadow table
 *  for a pt, rather than the pt itself (due to space concerns).  They are bits
 *  that won't be missed in the dbd.
 */
#define PG_NDREF	0x1		/* need reference bit (software) */
#define PG_LOCK		0x2		/* page lock bit (software) */

#define pg_clr(P,mask)	(P)->pgi.pg_pte &= ~(mask)
#define pg_set(P,mask)	(P)->pgi.pg_pte |= (mask)

/*	Set a new value into the protection field.			*/
/* BOBJ what if page already has protection, should clear prot before or'ing? */
#define pg_clrprot(P)	pg_clr(P, PG_PROT)
#define pg_setprot(P,V)	pg_set(P,V)

#define pg_setvalid(P)	pg_set(P, PG_V)
#define pg_clrvalid(P)	pg_clr(P, PG_V)

#define pg_setndref(P)	dbdget(P)->dbd_pg_ndref = 1
#define pg_clrndref(P)	dbdget(P)->dbd_pg_ndref = 0

#define pg_setlock(P)	dbdget(P)->dbd_pg_lock = 1
#define pg_clrlock(P)	dbdget(P)->dbd_pg_lock = 0
#define pg_getlock(P)	dbdget(P)->dbd_pg_lock

#define pg_setmod(P)	pg_set(P, PG_M)
#define pg_clrmod(P)	pg_clr(P, PG_M)

#define pg_setcw(P)	pg_set(P, PG_COPYW)
#define pg_clrcw(P)	pg_clr(P, PG_COPYW)

#define pg_setcm(P)	pg_set(P, PG_CM)
#define pg_clrcm(P)	pg_clr(P, PG_CM)

#define pg_setref(P)	pg_set(P, PG_REF)
#define pg_clrref(P)	pg_clr(P, PG_REF)

#define pg_chkmod(P)	((P)->pgm.pg_mod) 
#define pg_chkref(P)	((P)->pgm.pg_ref) 
#define pg_chkndref(P)	(dbdget(P)->dbd_pg_ndref)
#define pg_locked(x)	(dbdget(x)->dbd_pg_lock)

#define pg_zero(P)	{	register pte_t *lP = P;\
				(lP)->pgi.pg_pte = 0;\
				*((int *)(dbdget(lP))) = 0;\
			}
#define ppg_zero(P)	pg_zero(P)

/* Find disk block descriptor table corresponding to page table. */
#define dbdget(pt)	((dbd_t *)((unsigned int)pt + PT_NSWAP_SZ))

#ifndef LOCORE
extern unsigned int *nendp;
#endif

/*	The following macro takes a page table entry and modifies
**	it as required in order to be able to do dma.
*/

#define	pg_dmaok(P)	((P) & (PG_ADDR | PG_ALL))
#define	wdtmaok(dpgi,spgi)			\
		(dpgi).pg_pte = pg_dmaok(spgi.pg_pte);

/*
 *	Each page table is followed by a "shadow table", a block of disk
 *	block descriptors that give the location on disk where a
 *	copy of the corresponding page is found.  If the page
 *	is on swap, it is always a single block.  However, if
 *	it is on a regular file, a single page may correspond
 *	to a number of non-consecutive disk blocks.
 */

/*
 *  Two flags (dbd_pg_*) are moved to the shadow table, since there is
 *   no room in the pte for them, what with 040 support.  These are only
 *   meaningful at the page level, so there is no loss in putting them here.
 */
#ifndef LOCORE		/* Logical dbd structure */
typedef struct dbd {
	unsigned int	dbd_pg_lock: 1; /* Lock this page in core		*/
	unsigned int	dbd_pg_ndref:1; /* Needs a reference			*/
	unsigned int	dbd_type  :  3;	/* The values for this field are given	*/
				/* below.				*/
	unsigned int	dbd_swpi  :  3;	/* The index into swaptab for the	*/
				/* device this page is on if dbd_type	*/
				/* is DBD_SWAP.				*/
	unsigned int	dbd_blkno : 24;	/* The block number or i_map index.	*/
} dbd_t;
#endif

/* dbd_type values */
#define	DBD_NONE	0	/* There is no copy of this page on	*/
				/* disk.				*/
#define	DBD_SWAP	1	/* A copy of this page is on block nbr	*/
				/* dbd_blkno of the swap file		*/
				/* swptbl[dbd_swpi].			*/
#define	DBD_FILE	2	/* A copy of this page is on the file	*/
				/* described by the inode r_vptr.  The	*/
				/* dbd_blkno field is an index into the	*/
				/* i_map list pointed to by the inode.	*/
				/* It is the start of a list of block	*/
				/* number which contain a copy of the	*/
				/* page.				*/
#define DBD_LSTFILE	3	/* Same as DBD_FILE except that		*/
				/* this is the last page of the region	*/
#define	DBD_DZERO	4	/* This is a demand zero page.	No	*/
				/* space is allocated now.  When a	*/
				/* fault occurs, allocate a page and	*/
				/* initialize it to all zeros.		*/
#define	DBD_DFILL	5	/* This is a demand fill page.	No	*/
				/* space is allocated now.  When a	*/
				/* fault occurs, allocate a page and	*/
				/* do not initialize it at all.	 It	*/
				/* will be initialized by reading in	*/
				/* data from disk.			*/
#ifndef LOCORE
#ifdef KERNEL
extern pte_t *ptblalloc();
#endif
#endif

#endif /* __sys_page_h */
