#if !defined(__sys_ncr_h)
#define __sys_ncr_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/ncr.h	1.8 91/07/10 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

#if !defined(__sys_types_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:types.h"
# else
#   include <sys/types.h>
# endif
#endif 

/*
 *	ncr.h -- interface to NCR 5380 SCSI chip.
 */

struct	ncr5380 {
    u_char curr_data;		/* 000 R   Current SCSI data */
    u_char fill1[15];
    u_char init_comm;		/* 010 R/W Initiator Command */
    u_char fill2[15];
    u_char mode;		/* 020 R/W Mode */
    u_char fill3[15];
    u_char targ_comm;		/* 030 R/W Target Command */
    u_char fill4[15];
    u_char curr_stat;		/* 040 R   Current Status */
    u_char fill5[15];
    u_char bus_status;		/* 050 R   Bus and Status bits*/
    u_char fill6[15];
    u_char in_data;		/* 060 R   Input Data */
    u_char fill7[15];
    u_char respar_int;		/* 070 R   Reset Parity/Ints */

    /* The Mac IIfx has DMA hardware too: */

    u_char fill8[15];
    u_long dmactl;		/* 080 R/W DMA Control register */

    u_char f9[0x0c0-0x080-4];
    u_long	dma_count;	/* 0c0 R/W DMA bytecount */
    u_char fa[0x100-0x0c0-4];
    caddr_t	dma_addr;	/* 100 R/W DMA address */
    u_char fb[0x140-0x100-4];
    u_long	wdog_timer;	/* 140 R/W wdog timer count (1/4 CPU speed) */
    u_char fc[0x180-0x140-4];
    u_long	fifo;		/* 180 R   FIFO data register */
};

/* Bits in the dma control register. NB: We must always access this
 * register as a longword, so we have to read/modify/write the values
 * by using a junk variable to do it cleanly.
 */

#define SCSI_WONARB		0x2000	/* SCSI chip won auto bus arbitration */
#define SCSI_ARBEN		0x1000	/* enable auto bus arbitration */
#define SCSI_IDMASK		0x0e00	/* ID bits for auto arbitration */
#define SCSI_DMABUSERR		0x0100	/* DMA halted due to bus error */
#define SCSI_WDPENDING		0x0080	/* watchdog interrupt pending */
#define SCSI_SCSIPENDING	0x0040	/* SCSI interrupt pending */
#define SCSI_FIFOTEST		0x0020	/* enable FIFO test mode */
#define SCSI_FIFODATA		0x0010	/* some bytes left in FIFO */
#define SCSI_HSENAB		0x0008	/* enable hardware handshake */
#define SCSI_WDIRQENAB		0x0004	/* enable watchdog interrupts */
#define SCSI_NCRIRQENAB		0x0002	/* enable SCSI (53C80)interrupts */
#define SCSI_DMAENAB		0x0001	/* enable DMA data transfers */
#define SCSI_RESET5380	 SCSI_FIFODATA	/* reset the 53C80 cell */

#define out_data	curr_data	/* W   Output Data 	 */
#define sel_ena		curr_stat	/* W   Select Enable	 */
#define start_xmt	bus_status	/* W   Start DMA SCSI xmit */
#define start_Trcv	in_data		/* W   Start Target SCSI rcv */
#define start_Ircv	respar_int	/* W   Start Initiator SCSI rcv */

/*  register read macros - parameter is mask */
#define  CS(m)  (ncr->curr_stat  & (m))
#define  BS(m)	(ncr->bus_status & (m))
#define  IC(m)	(ncr->init_comm  & (m))
#define  TC(m)	(ncr->targ_comm  & (m))
#define  MD(m)	(ncr->mode       & (m))

/* register write macros - param1 bits to clear, param2 bits to set */
#define cs(c,s) (ncr->curr_stat  = CS(~(c)) | s)
#define bs(c,s) (ncr->bus_status = BS(~(c)) | s)
#define ic(c,s) (ncr->init_comm  = IC(~(c)) | s)
#define tc(c,s) (ncr->targ_comm  = TC(~(c)) | s)
#define md(c,s) (ncr->mode       = MD(~(c)) | s)

/*	Initiator Command register bits */

#define	SIC_DB	0x01	/* Data bus */
#define	SIC_ATN 0x02	/* ATN line */
#define	SIC_SEL	0x04	/* SEL line */
#define	SIC_BSY	0x08	/* BSY line */
#define	SIC_ACK	0x10	/* ACK line */
#define	SIC_LA  0x20	/* Lost arbitration */
#define	SIC_AIP 0x40	/* Arbitration in progress */
#define	SIC_RST	0x80	/* Reset line */

/*	Mode register bits */

#define	SMD_ARB	0x01	/* Arbitration */
#define	SMD_DMA	0x02	/* DMA transfer enable */
#define	SMD_EOP	0x08	/* enable EOP interrupt */
#define	SMD_BSY	0x04	/* monitor busy */

/*	Target Command Register bits */

#define	STC_IO	0x01
#define	STC_CD	0x02
#define	STC_MSG	0x04
#define	STC_REQ	0x08
#define	STC_LBS	0x80	/* last byte sent (53C80 only) */

/*	Current status register bits */

#define SCS_SEL 0x02	/* Select line */
#define SCS_PMK (7<<2)	/* Phase bits MasK */
#define SCS_IO  0x04	/* I/O line */
#define	SCS_REQ	0x20	/* REQ line */
#define	SCS_BSY	0x40	/* BSY line */
#define SCS_RST 0x80	/* Reset line */

/*	Bus status register bits */

#define SBS_ACK   0x01  /* ack */
#define SBS_ATN   0x02  /* atn */
#define	SBS_BSY	  0x04	/* busy Error */
#define	SBS_PHASE 0x08	/* Phase match */
#define	SBS_IRQ	  0x10	/* Interrupt requested */
#define SBS_PTE   0x20  /* Parity Error */
#define	SBS_DMA	  0x40	/* DMA request bit */
#define	SBS_EOP	  0x80	/* DMA EOP */

#if defined(KERNEL) || defined(STANDALONE)
extern	char *scsi_strings[];
#endif

#ifdef	STANDALONE
#define SCSI_ADDR	0x50F10000
#define	SDMA_ADDR	sdma_addr	/* SCSI special DMA register */
#define VIA1_ADDR	0x50F00000	/* VIA1 virtual addr (0x2000 long) */
#define VIA2_ADDR	0x50F02000	/* VIA2 virtual addr (0x2000 long) */
#define	SDMA_ADDR_R7	0x50F14000	/* SCSI special DMA register */
#define	SDMA_ADDR_R8	0x50F12000	/* SCSI special DMA register */
#endif

#endif /* __sys_ncr_h */
