#if !defined(__sys_heap_kmem_h)
#define __sys_heap_kmem_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/heap_kmem.h	1.7 91/11/07 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1983-87 Sun Microsystems, Inc. */

#if !defined(__sys_types_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:types.h"
# else
#   include <sys/types.h>
# endif
#endif 

/*
 * The node header structure.
 * 
 * To reduce storage consumption, a header block is associated with
 * free blocks only, not allocated blocks.
 * When a free block is allocated, its header block is put on 
 * a free header block list.
 *
 * This creates a header space and a free block space.
 * The left pointer of a header blocks is used to chain free header
 * blocks together.
 */

typedef enum {false,true} bool;
typedef struct	freehdr	*Freehdr;
typedef struct	dblk	*Dblk;

/*
 * Description of a header for a free block
 * Only free blocks have such headers.
 */
struct 	freehdr	{
	Freehdr	left;			/* Left tree pointer */
	Freehdr	right;			/* Right tree pointer */
	Dblk	block;			/* Ptr to the data block */
	u_int	size;			/* Size of the data block */
};

#define NIL		((Freehdr) 0)
		#undef NULL
#define	NULL		0
#define WORDSIZE	sizeof (int)
#define	SMALLEST_BLK	1	 	/* Size of smallest block */

/*
 * Description of a data block.  
 */
struct	dblk	{
	char	data[1];		/* Addr returned to the caller */
};

/*
 * weight(x) is the size of a block, in bytes; or 0 if and only if x
 *	is a null pointer. It is the responsibility of kmem_alloc() and
 *	kmem_free() to keep zero-length blocks out of the arena.
 */

#define	weight(x)	((x) == NIL? 0: (x->size))
#define	nextblk(p, size) ((Dblk) ((char *) (p) + (size)))
#define	max(a, b)	((a) < (b)? (b): (a))

Freehdr	getfreehdr();
int	morecore();
caddr_t	kmem_alloc();

/*
 * Structure containing various info about allocated memory.
 */
#define	NEED_TO_FREE_SIZE	10
#define MAX_KMEM_TREE 20	/* max. number of trees */

/* info for each kmem_tree */
struct kmem_info {
	Freehdr free_root; 	/* root node */
	caddr_t start;		/* first address of the tree */
	caddr_t end;		/* last address of the tree */
	u_int	nbytes;		/* space allocated for the tree */
	short  	oldness;	/* how long the tree is not in use */
	short	invalid;	/* tree is not allocated */
} kmem_tree[MAX_KMEM_TREE];

/* one list of free header per system */
Freehdr free_hdr_list;
struct need_to_free {
	caddr_t addr;
	u_int	nbytes;
} need_to_free_list,need_to_free[NEED_TO_FREE_SIZE];

#endif /* __sys_heap_kmem_h */
