#if !defined(__stdlib_h)
#define __stdlib_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:stdlib.h	1.13 91/07/01 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/*
 * [ANSI C] ANSI X3.159-1989 (4.10) General Utilities
 */

#if !defined(_SIZE_T) && !defined(__size_t__)
# define  _SIZE_T			/* make AT&T happy */
# define  __size_t__			/* make MPW happy */
#ifndef __SIZE_TYPE__
#define __SIZE_TYPE__ long unsigned int
#endif
#ifndef _GCC_SIZE_T
#define _GCC_SIZE_T
  typedef __SIZE_TYPE__ size_t;
#endif
#endif

#if !defined(_WCHAR_T) && !defined(__wchar_t__)
# define  _WCHAR_T			/* make AT&T happy */
# define  _GCC_WCHAR_T__			/* make MPW happy */
#ifndef __WCHAR_TYPE__
#define __WCHAR_TYPE__ int
#endif
#ifndef __cplusplus
  typedef __WCHAR_TYPE__ wchar_t;
#endif
#endif

#if !defined(_DIV_T) && !defined(__div_t__)
# define  _DIV_T			/* make AT&T happy */
# define  __div_t__			/* make MPW happy */
  typedef struct {
  	int quot;		/* quotient */
	int rem;		/* remainder */
  } div_t;
#endif

#if !defined(_LDIV_T) && !defined(__ldiv_t__)
# define  _LDIV_T			/* make AT&T happy */
# define  __ldiv_t__			/* make MPW happy */
  typedef struct {
  	long int quot;		/* quotient */
	long int rem;		/* remainder */
  } ldiv_t;
#endif

#if !defined(NULL)
# define NULL 0
#endif

#define EXIT_FAILURE 	1	/* exit(EXIT_FAILURE) */
#define EXIT_SUCCESS 	0	/* exit(EXIT_SUCCESS) */
#define MB_CUR_MAX   	1	/* max bytes in multibyte character */
#define RAND_MAX	32767	/* max value from rand() */

#if defined(__STDC__)

  double   atof(const char *nptr);
  int      atoi(const char *nptr);
  long int atol(const char *nptr);
  double   strtod(const char *nptr, char **endptr);
  long int strtol(const char *nptr, char **endptr, int base);
  int      rand(void);
  void     srand(unsigned int seed);
  void     *calloc(size_t nmemb, size_t size);
  void     free(void *ptr);
  void     *malloc(size_t size);
  void     *realloc(void *ptr, size_t size);
  void     abort(void);
  void	   exit(int status);
  char     *getenv(const char *name);
  int      system(const char *string);
  void     *bsearch(const void *key, const void *base, size_t nmemb,
	     size_t size, int (*compar) (const void *, const void *)); 
  void     qsort(void *base, size_t nmemb, size_t size,
	     int (*compar) (const void *, const void *)); 
  int      abs(int j);
  unsigned long int strtoul(const char *nptr, char **endptr, int base);
  int      atexit(void (*func)(void));
  div_t    div(int numer, int denom);
  long int labs(long int j);
  ldiv_t   ldiv(long int numer, long int denom);
  int      mblen(const char *s, size_t n);
  int      mbtowc(wchar_t *pwc, const char *s, size_t n);
  int      wctomb(char *s, wchar_t wchar);
  size_t   mbstowcs(wchar_t *pwcs, const char *s, size_t n);
  size_t   wcstombs(char *s, const wchar_t *pwcs, size_t n);

#else /* not __STDC__ */
  /*
   * POSIX requires this ANSI C interface for "common" C implementations.
   */

  char     *getenv();
  char     *bsearch();
  void *	calloc();
  void *	malloc();
  void *	realloc();
  double   atof();
  double   strtod();
  long     atol();
  long     strtol();
  void     srand();
  void     exit();
  void     free();
  void     qsort();
#endif /* __STDC__ */

#endif /* __stdlib_h */
#if defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__)
extern int putenv (char *);
#endif /* defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__*/
