
/*
 *	Copyright (c) 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)nbp.h: 2.0, 1.6; 7/26/89; Copyright 1988-89, Apple Computer, Inc. */


#ifndef __NBP__
#define __NBP__

/* NBP DDP socket type */
#define  NBP_DDP_TYPE		0x02  	/* NBP packet */

/* NBP DDP socket number */
#define  NBP_SOCKET		0x02  	/* NIS socket number */


/* NBP packet types */

#define NBP_BRRQ		0x01  	/* Broadcast request */
#define NBP_LKUP    		0x02  	/* Lookup */
#define NBP_LKUP_REPLY		0x03  	/* Lookup reply */
#define NBP_REGISTER    	0x07	/* Register a name */
#define NBP_DELETE      	0x08	/* Delete a name */
#define NBP_CONFIRM   		0x09	/* Confirm, not sent on wire */
#define NBP_STATUS_REPLY	0x0a	/* Status on register/delete */
#define	NBP_CLOSE_NOTE		0x0b	/* Close notification from DDP */


/* Protocol defaults */

#define NBP_RETRY_COUNT		8	/* Maximum repeats */
#define NBP_RETRY_INTERVAL	1	/* Retry timeout */


/* Special (partial) wildcard character */
#define	NBP_SPL_WILDCARD	0xC5
#define	NBP_ORD_WILDCARD	'='


/* NVE strings */
#define NBP_NVE_STR_SIZE	32	/* Maximum NBP tuple string size */
typedef struct at_nvestr {
	u_char		len;
	u_char		str[NBP_NVE_STR_SIZE];
} at_nvestr_t;


/* Entity Name */

typedef struct at_entity {
	at_nvestr_t	object;
	at_nvestr_t	type;
	at_nvestr_t	zone;
} at_entity_t;


/* Packet definitions */

#define NBP_TUPLE_SIZE	99	/* 3 for field lengths + 3*32 for three names */
#define NBP_TUPLE_MAX	15	/* Maximum number of tuples in one DDP packet */
#define	NBP_HDR_SIZE	2

typedef struct at_nbptuple {
	at_inet_t	enu_addr;
	union {
	  struct {
            u_char	enumerator;
	    at_entity_t entity;
	  } en_se;
	  struct {
            u_char	enumerator;
            u_char	name[NBP_TUPLE_SIZE];
	  } en_sn;
	} en_u;
} at_nbptuple_t;

/* Some macros for easier access to the tuple union */
#define	enu_enum	en_u.en_sn.enumerator
#define	enu_name	en_u.en_sn.name
#define	enu_entity	en_u.en_se.entity


typedef struct at_nbp {
#if defined(__vax__) || defined(sequent) || defined(__sun386__)
	u_char		tuple_count : 4,
			control : 4;
#else
        u_char      	control : 4,
        	      	tuple_count : 4;
#endif
        u_char      	id;
	at_nbptuple_t	tuple[NBP_TUPLE_MAX];
} at_nbp_t;

#endif

