
/*
 *	Copyright (c) 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)atp_cb.h: 2.0, 1.6; 7/10/91; Copyright 1988-89, Apple Computer, Inc. */

#ifndef __ATPCB__
#define __ATPCB__

#if defined(__MPW_C__)
# include "/:usr:include:at:atlog.h"
#else
# include <at/atlog.h>
#endif

/* ATP internal definitions.  Used by ATP protocol modules.  These
 * definitions are subject to change; do not use them in applications.
 */

/* ATP user bytes - allow access as char, short, or long.
 * User must take care of network order.
 */
typedef union AtpUserData {
   u_char	b[4];
   u_short	s[2];
   u_long	l;
} AtpUserData_t;

/*
 * ATP Request Block 
 *
 * The AtpRB contains the context and status for all ATP user requests.
 * When the request completes, the completion routine is called with a pointer 
 * to this struct as its only parameter.
 */
typedef struct AtpRB {
   struct AtpRB *FwdLink;
   struct AtpRB *BwdLink;
   MEM_T	*mp;			/* MEM_T pointer for this AtpRB_t */
   void		*q;			/* Streams q for this socket (opaque) */
   void		*UpperMp;		/* Opaque pointer for caller's use */
   at_inet_t    NetAddr;                /* Remote internet address */
   MEM_T        *ReqBufMp;              /* Request packet ptr */
   char		*ReqBufUp;              /* User request data ptr */
   short        ReqLength;              /* Returned length of request */
   AtpUserData_t ReqUserData;           /* Storage for user u_chars */
   at_retry_t   ReqRetry;               /* Request retry */
   u_long       ReqDelta;               /* Request round-trip time */
   u_long       ReqNumRetrans;          /* Number of requests taken to complete transaction */
   u_short      TransID;                /* Location to receive TID */
   u_char       XOMode;                 /* Storage for XO mode flag */
   u_char	XORelTimer;		/* Release timer for XO transaction */
   u_char       BitMap;                 /* Location for bitmap of responses expected */
   MEM_T        *RespData[ATP_TRESP_MAX]; 	/* Response data ptrs */
   char         *RespDataUp[ATP_TRESP_MAX]; 	/* User's response data ptrs */
   short        RespLen[ATP_TRESP_MAX];   	/* Response data lengths */
   AtpUserData_t RespUserData[ATP_TRESP_MAX];/* Response user data */
   u_long       Status;                 /* ATP request completion status */
   void         (*Completion)();        /* ATP request completion routine */
   u_char	Filler[3];
   char		Data[1];
} AtpRB_t;


/* ATP streams module ioctls */

#define ATP_IOC_MYIOCTL(i)      ((i>>8) == AT_MID_ATP)
#define ATP_IOC_GET_REQ         ((AT_MID_ATP<<8) | 1)
#define ATP_IOC_SND_RSP         ((AT_MID_ATP<<8) | 2)
#define ATP_IOC_SND_REQ         ((AT_MID_ATP<<8) | 3)
#define ATP_IOC_CAN_REQ         ((AT_MID_ATP<<8) | 4)
#define ATP_IOC_CAN_RSP         ((AT_MID_ATP<<8) | 5)


/* ATP module internal data structures */

/*
 * Request Control Block (RqCB).
 *
 * A RqCB is created whenever a client opens an ATP socket.
 * The RqCB maintains, on a per socket basis, a queue
 * of outstanding ATP Get Requests.  This allows for multiple Get
 * Requests to be issued asynchronously by an ATP responder.
 */
struct RqCB {
   struct RqCB 	*FwdLink;
   struct RqCB 	*BwdLink;
   char 	*private;		/* Pointer to user's opaque data */
   MEM_T 	*mp;			/* MEM_T pointer for this RqCB */
   at_socket 	Skt;                    /* Socket to receive request on */
   MEM_T	*PendingReq;		/* Cache for 1 req. dgram if no GetReq active */
   AtpRB_t	*GetRqFwdLink;          /* Queue of pending Get requests */
   AtpRB_t	*GetRqBwdLink;          /* Queue of pending Get requests */
};

/*
 * Transaction Control Block (TCB).
 *
 * The TCB contains the context and status of currently active ATP
 * Requests, those awaiting a response.
 */
struct TCB {
   struct TCB 	*FwdLink;
   struct TCB 	*BwdLink;
   struct RqCB 	*RqCBPtr;		/* RqCB structure for this socket */
   MEM_T 	*mp;			/* MEM_T pointer for this TCB */
   MEM_T 	*ddpmp;                 /* ddp Request Pkt */
   at_socket 	Skt;                    /* Socket request was sent on */
   u_char 	RcvdBitMap;         	/* Bitmap of responses received */
   u_long	ReqDeltaStart;		/* Start time of request */
   u_long 	RetryTime;          	/* Retry timer event time */
   AtpRB_t	*AtpRBPtr;		/* Request block ptr */
};

#define TCBRBPtr	TCBPtr->AtpRBPtr		/* TCB Request block ptr */
#define TCBRBRetry	TCBPtr->AtpRBPtr->ReqRetry	/* TCB Request block retry struct */

/*
 * Response Control Block (RpCB).
 *
 * The RpCB is created on behalf of XO (exactly-once) requests.  The
 * RpCB keeps track of XO requests for duplicate transaction-request
 * filtering.
 */
struct RpCB {
   struct RpCB 	*FwdLink;
   struct RpCB 	*BwdLink;
   struct RqCB 	*RqCBPtr;		/* RqCB structure for this socket */
   MEM_T 	*mp;			/* MEM_T pointer for this RpCB */
   at_inet_t	ReqNetAddr;		/* Address of requesting socket */
   at_socket 	Skt;                    /* Responder's socket address */
   u_char	RespSent;		/* TRUE if the response has been sent */
   u_char 	EOMRespNo;              /* Response number of EOM */
   u_long 	ReleaseTime;            /* Release timer event time */
   AtpRB_t	*AtpRBPtr;		/* Request block ptr */
};

#define RPRBPtr	RpCBPtr->AtpRBPtr	/* RP Request block ptr */

#endif
