
/*
 *	Copyright (c) 1987, 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)adsp_cb.h: 2.0, 1.5; 7/10/91; Copyright 1987-89, Apple Computer, Inc."; */


#ifndef __ADSP_CB__
#define __ADSP_CB__

#if defined(__MPW_C__)
# include "/:usr:include:at:appletalk.h"
#else
# include <at/appletalk.h>
#endif
#if defined(__MPW_C__)
# include "/:usr:include:at:ddp.h"
#else
# include <at/ddp.h>
#endif
#if defined(__MPW_C__)
# include "/:usr:include:at:adsp.h"
#else
# include <at/adsp.h>
#endif
#if defined(__MPW_C__)
# include "/:usr:include:at:atlog.h"
#else
# include <at/atlog.h>
#endif


/* Connection opening modes */

#define ADSP_OM_OPEN 1
#define ADSP_OM_LISTEN 2
#define ADSP_OM_ACCEPT 4
#define ADSP_OM_ESTABLISH 8

/* Connection states */

#define Invalid 0			/* Invalid connection control block */
#define Listen 1			/* Waiting for an open con req */
#define Opening 2			/* No state info, sending open req */
#define MyHalfOpen 4			/* His state info, sending open req */
#define HisHalfOpen 8			/* He has my state info, sndng op req */
#define Open 16				/* Connection is operational */
#define TornDown 32			/* Probe timer has expired max times */
#define Closing 64			/* Client requests close, emptying send Queues */
#define Closed 128			/* Close advice rcvd, emptying rcv queues */

/* Timer identifications */

#define OpenReq 0			/* Open request timer */
#define Probe 1				/* Connection probe timer */
#define FwdRst 2			/* Forward reset timer*/
#define Attn 3				/* Send attention message timer */
#define Trans 4				/* Transmit unsent bytes timer */
#define ReTrans 5			/* Retransmit sent bytes timer */
#define SndWdwClo 6			/* Send window closed timer */
#define Restart 7			/* Restart sender timer */
#define ResLow 8			/* Resources are low timer */
#define TimerCnt 9			/* Number of timers */

/* Miscellaneous constants */

#define ADSP_MAXCON 256			/* Maximum number of connections */
#define ACTSize (ADSP_MAXCON + 1)	/* Active connection table size */
#define SktTabSize 256			/* Socket table size */
#define ADSP_MAXWDWSIZE 0xFFFF		/* Maximum window size */
#define OneSec SYS_HZ			/* Seconds in ticks */
#define ConProbeIntrvl (30*OneSec)	/* Probe interval in seconds */


/* Connection Info - stored in streams q->q_ptr and used to associated a
 * queue with an ADSP connection.
 */

struct CInfo {
   unsigned 	 Refnum;
   unsigned char socket;
};

/* Send Buffer Control Block */

struct sbcb {
   struct sbcb *Flink;
   struct sbcb *Blink;
   /* The next four entries must match a ChainedBDS struct */
   unsigned *Chain;			/* Chain to next transmision buffer */
   unsigned char *SndBufPtr;		/* Pointer to buffer for transmission */
   unsigned short SndCnt;		/* Number of bytes to transmit */
   mblk_t *mp;				/* Pointer to buffer message block */
   unsigned char *BufPtr;		/* Pointer to start of buffer */
   unsigned short ByteCnt;		/* Number of bytes in the buffer */
   unsigned short EOM : 1;		/* Buffer contains an EOM */
};

/* Received Buffer Control Block */

struct rbcb {
   struct rbcb *Flink;
   struct rbcb *Blink;
   mblk_t *mp;				/* Pointer to buffer message block */
   unsigned short ByteCnt;		/* Number of ADSP data bytes */
   unsigned short EOM : 1;		/* Buffer has an EOM attached */
};

/* Read Request Control Block */

struct rrcb {
   struct rrcb *Flink;
   struct rrcb *Blink;
   unsigned ReqLen;			/* Length of user read request */
   unsigned *ByteCnt;			/* Pointer to ADSP data byte count */
   mblk_t *mp;				/* Pointer to buffer message block */
   unsigned *EOM;			/* Pointer to End of Message flag */
   unsigned *CompStat;			/* Pointer to completion status */
   unsigned char EventFlag;		/* Event flag */
   unsigned (*ASTHandler)();		/* AST handler address */
   unsigned ASTParam;			/* AST parameter */
};

/* Received Attention Message Control Block */

struct ramcb {
   struct ramcb *Flink;
   struct ramcb *Blink;
   mblk_t	*mp;			/* Pointer to buffer */
};



/* ADSP Connection Control Block */

struct ccb {
   struct ccb *Flink;
   struct ccb *Blink;
   queue_t *q;				/* Streams write q */
   unsigned char Refnum;		/* Connection reference number */
   unsigned char State;			/* Connection State */

   /* Miscellaneous Flags */
   unsigned ConFwdRst : 1;	        /* The connection has been forwrd reset */
   unsigned ReTransExpired : 1;		/* True if retransmit timer expired */
   unsigned SndFwdRst : 1;		/* Send forward reset when res low expires */
   unsigned SndAck : 1;			/* Send ack when res low timer expires*/
   unsigned SndAckReq : 1;		/* Send ack request when res low expire */
   unsigned SndAttnMsg : 1;		/* Send attn msg when res low expires */
   unsigned SndAttnAck : 1;		/* Send attn msg ack when res low expire */
   unsigned SndOpnReq : 1;		/* Send open req when res low expires */
   unsigned char ReplCnt;		/* Replace dgrams when res low expire */
   unsigned char OutOfSeqPkts;		/* Number of out of sequence packets */

   /* Local/Remote Internet Addresses */
   struct at_inet Rem;			/* Remote socket address */
   struct at_inet Loc;			/* Local socket address */
   unsigned short RemCID;		/* Remote Connection ID */
   unsigned short LocCID;		/* Local Connection ID */

   /* Sequence Numbers */
   unsigned SndSeq;			/* First usent byte */
   unsigned FirstRtmtSeq;		/* First byte to retransmit */
   unsigned SndWdwSeq;			/* Last byte in the send window */
   unsigned RcvSeq;			/* Next byte to accept from remote end */
   unsigned AttnSndSeq;			/* Next attention message number */
   unsigned AttnRcvSeq;			/* Next attention message to accept */
   unsigned short RcvWdw;		/* Current size of receive window */

   /* Send/Receive Queues */
   struct sbcb *SndQFlink;		/* Send queue forward link */
   struct sbcb *SndQBlink;		/* Send queue backward link */
   unsigned SndQByteCnt;		/* Number of unsent bytes in send queue */
   unsigned SndByteCnt;			/* Number of total bytes in send queue */
   unsigned SndQBufCnt;			/* Number of bufs in send queue */
   struct sbcb *SndSeqPtr;		/* Pointer to buf containing SndSeq */
   unsigned short SndSeqOff;		/* Offset into buf for SndSeq */
   unsigned short FirstRtmtOff;		/* Offset into first buf for FirstRtmtSeq */
   struct rbcb *RcvQFlink;		/* Receive queue forward link */
   struct rbcb *RcvQBlink;		/* Receive queue backward link */

   /* Open Request */
   unsigned char OpenMode;		/* Mode in which connection was opened */
   struct at_inet *OpenRemAddr;		/* Pointer to client's rem addr block */
   unsigned ConEvents;			/* connection events */
   unsigned *Filter;			/* Addr of filter list */
   unsigned *OpenCompStat;		/* Addr of open completion status */
   unsigned char OpenEventFlag;		/* Open completion event flag */
   unsigned (*OpenHandler)();		/* Open completion handler */
   unsigned OpenParam;			/* Open completion parameter */

   /* Close Request */
   unsigned *CloseCompStat;		/* Addr of open completion status */
   unsigned char CloseEventFlag;	/* Close completion event flag */
   unsigned (*CloseHandler)();		/* Close completion handler */
   unsigned CloseParam;			/* Close completion parameter */

   /* Read Request */
   struct rrcb *ReadQFlink;		/* Read request forward link */
   struct rrcb *ReadQBlink;		/* Read request backward link */

   /* Send Attention Message */
   mblk_t *SndAttnMblk;			/* Mblk_t of attn msg to transmit */
   unsigned char *SndAttnBufPtr;	/* Addr of attn msg to transmit */
   unsigned SndAttnLen;			/* Length of attn msg buffer */
   unsigned SndAttnByteCnt;		/* Number of bytes in the attn msg */
   unsigned short SndAttnCode;		/* Attention message code */
   unsigned *SndAttnCompStat;		/* Addr of send AM completion status */
   unsigned char SndAttnEventFlag;	/* Send attn msg completion event flag */
   unsigned (*SndAttnHandler)();	/* Send attn msg completion handler */
   unsigned SndAttnParam;		/* Send attn msg completion parameter */

   /* Receive Attention Message */
   struct ramcb *RcvAttnQFlink;		/* Received attn msg forward link */
   struct ramcb *RcvAttnQBlink;		/* Received attn msg backward link */
   mblk_t *RcvAttnMblk;			/* Receive attn mblk_t pointer */
   unsigned *RcvAttnLen;		/* Receive attn msg buffer length */
   unsigned char **RcvAttnDataPtr;	/* Receive attn msg data pointer */
   unsigned *RcvAttnByteCnt;		/* Receive attn msg data byte count */
   unsigned short *RcvAttnCode;		/* Receive attn msg code */
   unsigned *RcvAttnCompStat;		/* Receive attn msg completion status */
   unsigned char RcvAttnEventFlag;	/* Receive attn msg event flag */
   unsigned (*RcvAttnHandler)();	/* Receive attn msg handler */
   unsigned RcvAttnParam;		/* Receive attn msg completion param */

   /* Forward Reset */
   unsigned FwdRstSndSeq;		/* Saved forward reset send seq */
   unsigned *FwdRstCompStat;		/* Forward reset completion status */
   unsigned char FwdRstEventFlag;	/* Forward reset event flag */
   unsigned (*FwdRstHandler)();		/* Forward reset completion handler */
   unsigned FwdRstParam;		/* Forward reset completion parameter */

   /* Tuning Parameters */
   struct tpb TP;			/* Tuning Parameter Block */

   /* Timers */
   unsigned Timer[TimerCnt];		/* Pointers to timer queue elements */
   unsigned char OpenRetryCnt;		/* Open request retry count */
   unsigned char ProbeRetryCnt;		/* Connection probe retry count */
   unsigned short CurFwdRstIntrvl;	/* Current forward reset interval */
   unsigned short CurAttnIntrvl;	/* Current send attn msg interval */
   unsigned short CurReTransIntrvl;	/* Current retransmit timer interval */
   unsigned short CurSndWdwCloIntrvl;	/* Current send window closed interval*/
   unsigned short CurRestartIntrvl;	/* Current restart sender interval*/

   /* Counters */
   unsigned AttnAckRcvd;		/* Attn msg ack received */
   unsigned AttnAckAcptd;		/* Attn msg ack accepted */
   unsigned ProbeRcvd;			/* Probe received */
   unsigned AckRcvd;			/* Explicit ack msg received */
   unsigned FwdRstRcvd;			/* Forward reset received */
   unsigned FwdRstAcptd;		/* Forward reset accepted */
   unsigned FwdRstAckRcvd;		/* Forward reset ack received */
   unsigned FwdRstAckAcptd;		/* Forward reset ack accepted */
   unsigned AttnRcvd;			/* Attn msg received */
   unsigned AttnAcptd;			/* Attn msg accepted */
   unsigned DataRcvd;			/* Data msg received */
   unsigned DataAcptd;			/* Data msg Accepted */
   unsigned AckFieldChkd;		/* Ack field checked */
   unsigned AckNRSFieldAcptd;		/* Next receive seq field accepted */
   unsigned AckSWSFieldAcptd;		/* Send window seq field accepted */
   unsigned AckReqstd;			/* Ack requested */
   unsigned LowMem;			/* Low memory */
   unsigned OpnReqExp;			/* Open request timer expired */
   unsigned ProbeExp;			/* Probe timer expired */
   unsigned FwdRstExp;			/* Forward reset timer expired */
   unsigned AttnExp;			/* Attention timer expired */
   unsigned TransExp;			/* Transmit timer expired */
   unsigned ReTransExp;			/* Retransmit timer expired */
   unsigned SndWdwCloExp;		/* Send window closed timer expired */
   unsigned RestartExp;			/* Restart sender timer expired */
   unsigned ResLowExp;			/* Resources are low timer expired */
   unsigned RetransRcvd;		/* Retransmit Advice received */
};

/* Connection Listener Control Block */

struct clcb {
   struct at_inet *ClientRemAddr;
   unsigned short *ClientRemCID;
   unsigned short *ClientNextRcvSeq;
   unsigned short *ClientRcvWdw;
   unsigned short *ClientAttnRcvSeq;
   unsigned *CompStat;
   unsigned char EventFlag;
   unsigned (*ASTHandler)();
   unsigned ASTParam;
   struct at_inet RemAddr;
   unsigned short RemCID;
   unsigned short NextRcvSeq;
   unsigned short RcvWdw;
   unsigned short AttnRcvSeq;
};

/* Socket Table Element */

struct adspSktTableElement {
   struct ccb *Flink;
   struct ccb *Blink;
};

/* Timer identifier */

struct tid {
   unsigned char TimerID;		/* Timer identification */
   unsigned char Refnum;		/* Connection reference number */
   unsigned short LocCID;		/* Local connection identifier */
};

/* Chained Buffer Descriptor for use with DDP_write_chain */

struct ChainedBDS {
   struct ChainedBDS	*Chain;
   unsigned char	*SndBufPtr;
   unsigned short	SndCnt;
   mblk_t		*mp;
};

/* ADSP Open Connection packet format */

#define ADSPopenswap	"24421224"
#define ADSPopensize	21

struct ADSPopen {
   unsigned short SrcCID;
   unsigned FirstByteSeq;
   unsigned NextRcvSeq;
   unsigned short RcvWdw;
   unsigned char Control : 1,
		 AckReq : 1,
		 EOM : 1,
   		 Attention : 1,
		 ControlCode : 4;
   char rest[1];
   char filler[7];
   /* unsigned short Version;
   unsigned short DstCID;
   unsigned AttnRcvSeq; 
   ??? */
};

/* ADSP Data packet format */

#define ADSPdataswap 	"24421"
#define ADSPhdrsize	13

struct ADSPdata {
   unsigned short SrcCID;
   unsigned FirstByteSeq;
   unsigned NextRcvSeq;
   unsigned short RcvWdw;
   unsigned char Control : 1,
		 AckReq : 1,
		 EOM : 1,
   		 Attention : 1,
		 ControlCode : 4;
   unsigned char Data[1];
};

/* ADSP Attention Message packet format */

#define ADSPattnswap 	"244212"
#define ADSPattnsize	15

struct ADSPattn {
   unsigned short SrcCID;
   unsigned AttnSndSeq;
   unsigned AttnRcvSeq;
   unsigned short AttnRcvWdw;
   unsigned char Control : 1,
		 AckReq : 1,
		 EOM : 1,
   		 Attention : 1,
		 ControlCode : 4;
   unsigned short AttnCode;
   unsigned char Data[1];
};



#if !defined(__vax__)
#define	at_byteswap(pkt, pattern)	/* do not need */
#endif

struct q_header {
	struct q_header	*q_l_FwdLink;
	struct q_header	*q_l_BwdLink;
};



typedef	u_char	byte;
typedef	u_short	word;
typedef	u_long	longword;

#define	register	/* A/UX & 4.3 compilers don't allow & of register var */

/* Need to modify use of these 3 for multiple ports: ??? */
extern struct adspSktTableElement adspSktTable[];
extern struct ccb *ActConTable[];
extern unsigned short LastCID;

extern unsigned SBCBsize;
extern unsigned RBCBsize;
extern unsigned RRCBsize;
extern unsigned RAMCBsize;
extern unsigned CCBsize;
extern unsigned CLCBsize;
extern unsigned nil;
extern unsigned char DefEventFlag;

extern at_ddp_t *GetDatagram();
extern mblk_t	*DatagramToMblk();

/* debug stuff */
extern int	T_adsp;
#define ADSPTRACE(x)	if (T_adsp) adsp_trace x



/* Streams ioctl definitions */

#define	ADSP_IOC_MYIOCTL(i)	((i>>8) == AT_MID_ADSP)
#define	ADSP_IOC_OPEN		((AT_MID_ADSP<<8) | 1)
#define	ADSP_IOC_LISTEN		((AT_MID_ADSP<<8) | 2)
#define	ADSP_IOC_CLOSE		((AT_MID_ADSP<<8) | 4)
#define	ADSP_IOC_FLUSH		((AT_MID_ADSP<<8) | 5)
#define	ADSP_IOC_READ		((AT_MID_ADSP<<8) | 6)
#define	ADSP_IOC_SNDATTN	((AT_MID_ADSP<<8) | 7)
#define	ADSP_IOC_RCVATTN	((AT_MID_ADSP<<8) | 8)
#define	ADSP_IOC_GETINFO	((AT_MID_ADSP<<8) | 9)
#define	ADSP_IOC_CLRINFO	((AT_MID_ADSP<<8) | 10)
#define	ADSP_IOC_GETSTAT	((AT_MID_ADSP<<8) | 11)
#define	ADSP_IOC_GETDEFL	((AT_MID_ADSP<<8) | 12)
#define	ADSP_IOC_SETDEFL	((AT_MID_ADSP<<8) | 13)
#define	ADSP_IOC_FWDRESET	((AT_MID_ADSP<<8) | 14)
#define	ADSP_IOC_GETEVENT	((AT_MID_ADSP<<8) | 100)

/* The adsp ioctl command structure, whereby adsp user commands are passed
 * to and from the streams module.
 */

struct	adspcmd	{
    unsigned	refnum;		/* The connection reference number */
    unsigned	CompStatus;	/* completion status, returned in errno */
    caddr_t	ioc;		/* streams ioc message pointer */
    caddr_t	q;		/* streams write q */
    union {
	struct	adsp_open {
		struct at_inet	RemoteAddress;
		unsigned char	socket;
		struct at_inet	FilterList[10]; /* ??? */
		unsigned char	OPDefaults; /* ??? */
	} adsp_open;
	struct	adsp_listen {
		unsigned char	socket;
		struct at_inet	RemoteAddress;
		struct at_inet	FilterList[10]; /* ??? */
		unsigned char	OPDefaults; /* ??? */
	} adsp_listen;
	struct	adsp_close {
		unsigned	Wait;
	} adsp_close;
	struct	adsp_write {
		unsigned	len;
		unsigned	EOM;
		unsigned	Flush;
		unsigned	attnCode;
		char		Data[1];
	} adsp_write;
	struct	adsp_read {
		unsigned	len;
		unsigned	EOM;
		unsigned	attnCode;
		char		Data[1];
	} adsp_read;
	struct	adsp_get_set {
		char		Data[1];
	} adsp_get_set;
    } u;
};

#endif
