; Garden - Apple ][ Version (C) 2005 by Ventzislav Tzvetkov
;                                    http://drhirudo.hit.bg
;
; This game is also available for classic Amiga, Oric Atmos and
; Sinclair ZX Spectrum.
;
;	Assemble with: dasm Garden.s -oGarden.prog -f3 -v0 -DPACKED=0

#if PACKED

NOPACKED = 0             ; 1 for the Work Release , 0 for the public

#else

NOPACKED = 1

#endif
        processor 6502

PAGE		=	$E6             ;Selected page (#$20 or #$40)
HTAB		=	$24		;Horizontal Char Position.
VTAB		=	$25		;Vertical Char Position.
ACC		=	$45		;Saved Accumulator
IOSAVE		=	$FF4A		;Saves the registers at $45 etc..
IORESTORE	=	$FF3F		;Restore registers.
WAIT		=	$FCA8		;Wait A.
RESET		=	$3F3		;Reset vector.
PREAD		=	$FB1E		;Y = PDL(X).
SETPWRC		=	$FB6F		;Set reset vector.
KEYBOARD	=	$C000		;keyboard data (latched) (Read)
STROBE		=	$C010		;Clear bit 7 of keyboard data ($C000)
SPEAKER		=	$C030		;Speaker softswitch.

DELIMO		=	$84		;used in the divison subroutine
OSTATYK		=	$85		;DELIMO  = DELIMO/DELITEL
DELITEL		=	$86		;OSTATYK = DELIMO%DELITEL

;LevelNumber	=	$87		;Currently unused.

ScreenOffset    =	$88		;Pointer at the Screen.

L		=	$8A		;Variables in ZeroPage for speed.
X		=	$8B
Y		=	$8C
U		=	$8D
W		=	$8E
Q		=	$8F
Z		=	$90
N		=	$91
A		=	$92
B		=	$93
Score		=	$94		;$95 as well - it's a word.
TempScore	=	$96		;Another word.
HighScore	=	$98		;And another.

DELAYTIME	=	$A0		;It changes during the game.

InitialDelayTime =	#164		;Start speed.

;macros

	mac     pushxy
	txa
	pha
	tya
	pha
	endm

	include Garden.h

;Begin	4 byte DOS 3.3 header

	org GardenORG

#if NOPACKED
	org GardenORG-4	;DOS 3.3 header. 4 bytes before the actual
LONG	=	END-START	;Program.
	dc.b #<START		;Start Address lowbyte.
	dc.b #>START		;Start Address highbyte.
	dc.b #<LONG		;Size - lowbyte.
	dc.b #>LONG		;Size - highbyte.
#endif
START				;Inits
#if NOPACKED
	jsr MODEL		;Show Apple Model while drawing.
				;If packed - it's in the depack routine.
#endif

	lda #<TITLESC		;Set reset vector
	sta RESET-1		;to point of the start of the program
	lda #>TITLESC		;i.e. pressing RESET button will
	sta RESET		;do jmp GardenORG.
	jsr SETPWRC		;Actualize $3F4 on flag.
	lda #$20		;First page for a begin.
	sta PAGE

	lda #$E8		;Set the
	sta HighScore		;HighScore

#if NOPACKED
	lda #0			;to $00E8 for the internal version.
#else
	lda #$03		;to $03E8 for the public version.
#endif
	sta HighScore+1		;I.E. 1000.

TITLESC
	lda #$20
	cmp PAGE
	beq .1			;switch to the other page
	bne .2
.1	lda #$40
.2	sta PAGE
	jsr CLEAR		;Clear screen.

	lda #5
	sta VTAB
	ldx #239
TitleText
	lda #39
	sta HTAB
TitleGraf
	lda Title,X
	jsr DRAWCHAR
	dex
	dec HTAB
	bpl TitleGraf
	dec VTAB
	bpl TitleText

	lda #16
	sta VTAB
	ldx #199

SubTitleText
	lda #39
	sta HTAB
SubTitleGraf
	lda SubTitle,X
	jsr DRAWCHAR
	dex
	dec HTAB
	bpl SubTitleGraf
	dec VTAB
	dec VTAB
	lda VTAB
	cmp #6
	bne SubTitleText

	lda #19
	sta VTAB
	lda #30
	sta HTAB
	ldx #21

ButtonText
	lda ButtonPressText,x
	jsr DRAWCHAR
	dec HTAB
	dex
	bpl ButtonText

	lda #22
	sta VTAB

	ldx #38

Copyright
	lda CopyrightText-3,X
	jsr PUTXCHAR
	dex
	bne Copyright

        inc VTAB
        ldx #39
        stx HTAB


PRINTU  lda URLText,x
        jsr DRAWINVERSECHAR      ;print the URL line (inversed).
        dec HTAB
        dex
        bpl PRINTU

        lda $C057		;Switch to the appropriate
SHOW    lda PAGE		;Highresolution screenmode
        cmp #$20		;Check which page is default.
        bne PAGE2		;And select it.
        lda $C054		;First graphic page.
        jmp GFSW		;skip the second.
PAGE2   lda $C055		;switch to high res graphics.
GFSW    lda $C050		;switch to graphics.
        lda $C052		;full page (no mixed text/graphics).
        lda STROBE		;Clear the keystrobe.


TitleScreenCycle
     	lda KEYBOARD		;Keyboard data (latched).
	cmp #$A0		;Check for pressed Space.
	bne NoTSpace
StartGame
	jsr InitGame		;Set Initial values for a game.
	jmp LevelBegin
NoTSpace
	lda $C061		;Read Joystick button 1.
	bmi StartGame
	lda $C062               ;Read Joystick button 2.
	bmi StartGame
	clc			;Random seed.
	lda seed1		;Seed1+=1.
	adc #1
	sta seed1
	lda seed2
	adc #0			;Seed2+=Carry
	sta seed2
	jmp TitleScreenCycle	;Repeat the loop.

LevelBegin
	jsr CLEAR		;Clear the screen.
	ldx #8			;HTAB=8
	lda #0			;VTAB=N=Z=0=Q++
	sta VTAB
	sta N
	sta Z
	sta Q
	inc Q
	ldy #5			;Check if there is NewHighScore.
	lda Score+1		;At higher byte.
	cmp HighScore+1		;Compare.
	bcc ScoreDraw		;No.
	bne RealHighScore	;If not Equal - it's higher always.
	lda Score		;If equal check if the lowbyte is
	cmp HighScore		;higher.
	bcc ScoreDraw		;No - there is no new highscore.

RealHighScore
	jsr NewHighScore	;There is new highscore.

ScoreDraw			;Display the "Score:" text.
	lda ScoreText,y		;Get the values from the table.
	jsr PUTXCHAR		;And print them.
	dex			;Decrease horizontal position.
	dey			;Decrease table offset.
	bpl ScoreDraw		;Not zero yet - continue drawing.
	jsr PrintScore		;Print the current score.

	ldy #9			;10 characters for the text.
	ldx #33			;At 33th HTAB.

HighScoreDraw
	lda HighScoreText,y	;Get the values from the table (y=offset)
	jsr PUTXCHAR		;Print the character.
	dex			;Decrease the HTAB.
	dey			;Decrease the offset.
	bpl HighScoreDraw	;Check if finished.
	
	lda HighScore		;Copy the highscore.
	sta TempScore		;To the temporary score.
	lda HighScore+1		;cells (2 bytes = 1 word).
	sta TempScore+1		;The second byte.
	lda #34			;At 34th
	sta HTAB		;Horizontal position.
	jsr PrintHighScore	;From the second entrypoint.

	;Ingame Screen Drawing here.
	lda #4			;FORI=4TO37
	sta Loop
Border	lda #6
	ldx Loop
	ldy #4
	jsr PUTXYCHAR		;PLOTI,4,6 (6=brick)
	ldy #21
	lda #41
	sec
	sbc Loop
	tax
	lda #6
	jsr PUTXYCHAR		;PLOT41-I,21,6
	lda Loop
	lsr
	sta HLP2
	adc #2
	ldx #4
	tay
	lda #6
	jsr PUTXYCHAR		;PLOT4,2+I/2,6
	ldx #37
	lda #23
	sec
	sbc HLP2
	tay
	lda #6
	jsr PUTXYCHAR		;PLOT37,23-I/2,6

	lda #60
	jsr WAIT		;Some delay for animation effect.
	inc Loop		;++Loop
	lda Loop
	cmp #38			;while (Loop!=38);
	bne Border		;No - continue drawing the border.
	lda #6
	sta Loop		;FORI=6TO20

Grass	ldx #5
GrassDr	lda #5
	ldy Loop
	jsr PUTXYCHAR		;PLOTX,Loop,5
	inx
	lda #4
	jsr PUTXYCHAR		;PLOT++X,Loop,4
	inx
	cpx #37			;while (X!=37);
	bne GrassDr		;Continue drawing the grass on the line.
	inc Loop		;++Loop
	lda Loop
	cmp #21			;while (Loop!=21);
	bne Grass		;Continue with next line.
	dec Loop		;Loop=20
Stones	jsr Random		;Generate random number.
	and #%00011111		;Between 0 and 31.
	clc
	adc #5
	tax
YRand	jsr Random		;Generate random number.
	and #%00001111		;between 0 and 15.
	cmp #15
	beq YRand		;if (A==15) generate another random.
	adc #6
	tay
	lda #7
	jsr PUTXYCHAR		;PLOT5+RND(1)*31,6+RND(1)*14,7
	dec Loop		;--Loop.
	bne Stones		;if (Loop) {Draw more stones}

FXRand	jsr Random		;Generate another random number.
	and #%00011111		;between 0 and 31.
	clc
	adc #5			;Add 5 to it
	sta HTAB		;and store it.
	tay			;Transfer it to Y for taking Line offset.
FYRand	jsr Random		;Vertical random number.
	and #%00001111		;between 0 and 14.
	cmp #15			;15 is unneeded.
	beq FYRand		;if (YRand==15) FYRand;
	clc
	adc #6			;And 6 to it.
	sta VTAB		;Store the vertical position.
	asl			;multiply by 2 for word offset.
	tax			;Transfer it to the X index register.
	lda ScreenTable,x	;Take the lowbyte from the table.
	sta ScreenOffset	;Store it at the offset pointer (lowbyte).
	lda ScreenTable+1,x	;Take the highbyte from the table.
	sta ScreenOffset+1	;Store it at the highbyte of the pointer.
	lda (ScreenOffset),y	;A=SCRN(HTAB,VTAB)
	cmp #4			;if A==4
	beq DrawFlower		;DrawFlower
	cmp #5			;or A==5
	beq DrawFlower		;DrawFlower too.
	bne FXRand		;Else it's another flower or stone - again.

DrawFlower
	lda #8
	jsr DRAWCHAR		;PLOTHTAB,VTAB,8 (8=Flower).
	inc Loop		;++Loop
	lda Loop
	cmp L			;while (Loop!=L)
	bne FXRand

InitSprites
	ldx #36
	stx X			;X=36
	ldy #5
	sty Y			;Y=5
	lda #2
	jsr PUTXYCHAR		;PLOTX,Y,2 - Our hero.
	ldx L
	stx U			;U=L
	ldy #5
	sty W			;W=5
	lda #3
	jsr PUTXYCHAR		;PLOTU,W,3 - Guard.

		;Wait for joystick button or movement.
GameWait
	lda $C061		;Read Joystick button.
	bmi InGame
	lda $C062               ;Read Joystick button 2.
	bmi InGame
        ldx #0                  ;Read Joystick(0).
        jsr PREAD
        cpy #30			;pdl(0) < 30
        bcc InGame
        inx
        jsr PREAD		;Read Joystick(1).
        cpy #210		;pdl(1) >210
        bcs InGame
	bcc GameWait

InGame				;Game Loop.
	lda X
	sta A			;A=X
	lda Y
	sta B			;B=Y
        ldx #0                  ;Read Joystick(0).
        jsr PREAD
        cpy #30			;pdl(0) < 30
        bcc LeftKey
        cpy #210		;pdl(0) > 210
        bcs RightKey
        inx
        jsr PREAD		;Read Joystick(1).
        cpy #30			;pdl(1) < 30
        bcc UpKey
        cpy #210		;pdl(1) >210
        bcs DownKey
	jmp Guard		;If No Movement - jump to the Guard routine.

LeftKey	ldx X			;Check X
	cpx #6
	bcc Rest		;if X<6 go to Rest.
	dec X			;else --X
	bne Rest		
RightKey ldx X
	cpx #36
	bcs Rest		;if X>35 go to Rest.
	inc X			;else ++X
	bne Rest
UpKey   ldy Y
	cpy #6
	bcc Rest		;if Y<6 go to Rest.
	dec Y			;else --Y
	bne Rest
DownKey ldy Y
	cpy #20
	bcs Rest		;if Y>19 go to Rest.
	inc Y			;else ++Y

Rest
	lda Y
	asl			;J=SCRN(X,Y)
	tax
	lda ScreenTable,x
	sta ScreenOffset
	lda ScreenTable+1,x
	sta ScreenOffset+1
	ldy X
	lda (ScreenOffset),y
	cmp #7
	bne NoStone		;if J=7
	lda A
	sta X			;X=A
	lda B
	sta Y			;Y=B
	bne Guard
NoStone cmp #4
	bne NoGrass1
	jmp OneScore		;Stepped on Grass - one point.
NoGrass1 cmp #5
	bne NoGrass2
	jmp OneScore
NoGrass2 cmp #8
	bne NoFlower
	jmp TenScore		;Picked flower - ten points.
NoFlower

Move
	ldx A
	ldy B
	lda #0
	jsr PUTXYCHAR		;PLOTA,B,0
	lda #2
	ldx X
	ldy Y
	jsr PUTXYCHAR		;PLOTX,Y,2
	jsr PrintScore		;Print the Score, changed or not.

	lda L
	cmp N
	bne Guard		;IFN<LTHEN8ELSEL=L-(L<35)
	inc L
	lda L
	cmp #35
	bcc AdvanceLevel
	dec L

AdvanceLevel
	lda DELAYTIME
	sec
	sbc #4		;Speed up.
	cmp #86
	bcs SpeedUp
	lda #120	;Bonus - SlowDown
SpeedUp	sta DELAYTIME
	jmp LevelBegin

Guard
	lda U
	sta A		;A=U
	clc
	adc Q
	sta U		;U=U+Q
	lda W
	sta B		;B=W
	clc
	adc Z
	sta W		;W=W+Z
	cmp Y
	bne NoCollision
	lda U
	cmp X
	bne NoCollision
Collision
	ldx U
	ldy W
	lda #31
	jsr PUTXYCHAR	;Game over. Draw Rotated man.
	jmp GameOver

NoCollision
	lda U
	cmp #5
	bcc Changeit
	cmp #37
	bcs Changeit
	lda W
	cmp #21
	bcs Changeit
	cmp #5
	bcc Changeit
	bcs Change14

Changeit
	jmp Change20	;IFU<5ORU>36ORW>GORW<5THENU=A:W=B:GOSUBG:GOTO17

Change14		;IFSCRN(U,W)>ETHENU=A:W=B:GOSUBG:GOTO17
	lda W
	asl
	tax
	lda ScreenTable,x
	sta ScreenOffset
	lda ScreenTable+1,x
	sta ScreenOffset+1
	ldy U
	lda (ScreenOffset),y
	beq Change15
	jmp Change20

Change15
	;IFU<XANDSCRN(U+1,W)=ETHENQ=1:Z=0
	ldy U
	cpy X
	bcs Change15_2
	lda W
	asl
	tax
	lda ScreenTable,x
	sta ScreenOffset
	lda ScreenTable+1,x
	sta ScreenOffset+1
	iny
	lda (ScreenOffset),y
	bne Change15_2
	sta Z
	lda #1
	sta Q
	bne Change16

Change15_2	;IFU>XANDSCRN(U-1,W)=ETHENQ=-1:Z=0
	ldy U
	cpy X
	bcc Change16
	lda W
	asl
	tax
	lda ScreenTable,x
	sta ScreenOffset
	lda ScreenTable+1,x
	sta ScreenOffset+1
	dey
	lda (ScreenOffset),y
	bne Change16
	sta Z
	lda #-1
	sta Q

Change16
;IFQTHENIFW<YANDSCRN(U,W+1)=ETHENZ=1:Q=0ELSEIFW>YANDSCRN(U,W-1)=ETHENZ=-1:Q=0
	lda Q
	beq NoQ		;bne NoChange
	ldx W
	cpx Y
	bcs Change16_2
	inx
	txa
	asl
	tax
	lda ScreenTable,x
	sta ScreenOffset
	lda ScreenTable+1,x
	sta ScreenOffset+1
	ldy U
	lda (ScreenOffset),y
	bne Change16_2
	sta Q
	lda #1
	sta Z
NoQ	jmp NoChange

Change16_2
	ldx W
	cpx Y
	bcc NoQ
	dex
	txa
	asl
	tax
	lda ScreenTable,x
	sta ScreenOffset
	lda ScreenTable+1,x
	sta ScreenOffset+1
	ldy U
	lda (ScreenOffset),y
	bne NoQ
	sta Q
	lda #-1
	sta Z
	jmp NoChange

Change20
	lda A
	sta U	;U=A
	lda B
	sta W	;W=B

GLine	lda Q
	bne Change22	;IF Q THEN 22
	ldy U		;Else IFU<31ANDSCRN(U+1,W)=ETHENQ=1:Z=0
	cpy #31
	bcs Reverse
	lda W
	asl
	tax
	lda ScreenTable,x
	sta ScreenOffset
	lda ScreenTable+1,x
	sta ScreenOffset+1
	iny
	lda (ScreenOffset),y
	bne Reverse
	sta Z
	lda #1
	sta Q
	bne NoChange

Reverse			;Q=-Q:Z=-Z
	lda Q
	beq Reverse3	;if (!Q) {Can't change sign;}
	cmp #1		;if (Q==1) Q=-3;
	bne Reverse2
	lda #-3
Reverse2
	clc
	adc #2		;Q+=2; if (Q=-1) Q=1; if (Q==1) Q=-3+2=-1;
	sta Q
Reverse3
	lda Z
	beq Reverse5
	cmp #1
	bne Reverse4
	lda #-3
Reverse4
	clc
	adc #2
	sta Z
Reverse5
	jmp NoChange

Change22
	ldx W		;IF W<20
	cpx #20
	bcs Change23	;Else.
	inx		;SCRN(W+1,U)
	txa
	asl
	tax
	lda ScreenTable,x
	sta ScreenOffset
	lda ScreenTable+1,x
	sta ScreenOffset+1
	ldy U
	lda (ScreenOffset),y
	bne Change23
	sta Q
	lda #1
	sta Z
	bne NoChange

Change23
	ldx W		;IF W>6
	cpx #6		
	bcc Reverse	;Else.
	dex		;SCRN(W-1,U)
	txa
	asl
	tax
	lda ScreenTable,x
	sta ScreenOffset
	lda ScreenTable+1,x
	sta ScreenOffset+1
	ldy U
	lda (ScreenOffset),y
	bne Reverse
	sta Q
	lda #-1
	sta Z

NoChange
	lda #0
	ldx A
	ldy B
	jsr PUTXYCHAR		;PLOTA,B,0
	lda #3
	ldx U
	ldy W
	jsr PUTXYCHAR		;PLOTU,W,3

	jsr DELAY		;Wait Delaytime.

	jmp InGame

PrintScore	subroutine
	lda #9
	sta HTAB
	lda Score
	sta TempScore
	lda Score+1
	sta TempScore+1

PrintHighScore			;EntryPoint for the HighScore.
	lda #0
	sta VTAB
	ldx #4			;Print 5 digits.
.1	lda #16
.2	pha
	sec
	lda TempScore
	sbc PLNTBL,X
	pha
	lda TempScore+1
	sbc PLNTBH,X
	bcc .3			;Less than divisor.
	sta TempScore+1
	pla
	sta TempScore
	pla
	adc #0			;Increment digit.
	bne .2			;Always.
.3	pla
	pla
	jsr DRAWCHAR
	inc HTAB
	dex
	bpl .1
	rts

OneScore		;Adds one point to the score.
	clc
	lda Score
	adc #1
	sta Score
	lda Score+1
	adc #0
	sta Score+1
	bit SPEAKER
	jmp Move

TenScore		;Adds ten points to the score. Constant cycles.
	clc
	lda Score
	adc #10
	sta Score
	lda Score+1
	adc #0
	sta Score+1
	inc N
TenPointsSound subroutine
	ldx #240
.1	bit SPEAKER
	ldy #80
.2	dey
	bne .2
	bit SPEAKER
	dex
	bne .1
	jmp Move


PUTXYCHAR sty VTAB
PUTXCHAR stx HTAB
DRAWCHAR subroutine
	jsr IOSAVE
	lda #0
	sta HLP
	lda VTAB
	asl
	asl
	asl
	jsr $F411  ;gives in $26 and $27 first byte address
	lda $45    ;load the saved A
	asl        ;multiplicate by 8
	rol HLP
	asl
	rol HLP
	asl
	rol HLP
; end of multiplication
	sta $8
	lda HLP
	adc #>Characters ;Get charcter high address
	sta $9           ;and put it on $9
	lda #8
	sta HLP
	ldx #0
	ldy HTAB
.1	lda ($8,x)	;get character byte
	sta ($26),y	;put it on the graphics page
	inc $8
	bne .2
	inc $9
.2	lda #4		;!for addressing of
	clc		;!next row from
	adc $27		;!the graphic page
	sta $27
	dec HLP
	bne .1
	lda VTAB	;Store at the virtual Screen Memory as well.
	asl
	tax
	lda ScreenTable,x
	sta ScreenOffset
	lda ScreenTable+1,x
	sta ScreenOffset+1
	lda ACC
	ldy HTAB
	sta (ScreenOffset),y
        jmp IORESTORE		;restore registers

;INVERSEDRAW

DRAWINVERSECHAR subroutine
        jsr IOSAVE
        lda #0
        sta HLP
        lda VTAB
        asl
        asl
        asl
        jsr $F411  ;gives in $26 and $27 first byte address
        lda $45    ;load the saved A
        asl        ;multiplicate by 8
        rol HLP
        asl
        rol HLP
        asl
        rol HLP
; end of multiplication
        sta $8
        lda HLP
        adc #>Characters
        sta $9
        lda #8
        sta HLP
        ldx #0
        ldy HTAB
.1      lda ($8,x)
        eor #%01111111    ;invert the character byte
        sta ($26),y
        inc $8
        bne .2
        inc $9
.2      lda #4           ;!for addressing of
        clc              ;!next row from
        adc $27          ;!the graphic page
        sta $27
        dec HLP
        bne .1
        jmp IORESTORE    ;restore registers

DIVISION subroutine
         ldx #8
         lda #0
         sta OSTATYK
CYCLE    asl DELIMO
         rol OSTATYK
         sec
         lda OSTATYK
         sbc DELITEL
         BCC DECR
         sta OSTATYK
         inc DELIMO
DECR     dex
         bne CYCLE
         rts

DELAY   lda DELAYTIME
        jmp WAIT

PLAYSOUND subroutine
     lda SPEAKER
.2   dey
     bne .1
     dec DURATION
     beq RTSS
.1   dex
     bne .2
     ldx PITCH
     jmp PLAYSOUND
RTSS rts

CLEAR subroutine
	lda #0
	sta $1C
	lda $E6
	sta $1B
	ldy #0
	sty $1A
.2	lda $1C
	sta ($1A),y
	jsr .3
	iny
	bne .2
	inc $1B
	lda $1B
	and #$1F
	bne .2
	lda #23
	sta VTAB
.5	lda VTAB		;Clear the virtual Screen as well.
	asl
	tax
	lda ScreenTable,x
	sta ScreenOffset
	lda ScreenTable+1,x
	sta ScreenOffset+1
	lda #0
	ldy #39
.6	sta (ScreenOffset),y
	dey
	bpl .6
	dec VTAB
	bpl .5
	rts
.3	asl
	cmp #$C0
	bpl .4
	lda $1C
	eor #$7F
	sta $1C
.4	rts 

Random subroutine	;Returns Random Number in A
	inc seed2	;calculate pseudo random number.
	lda seed2
	clc
	adc seed1
	adc seed2
	sta seed1
	eor seed2
	sta seed2
	sbc prevr
	sta prevr
	rts

NewHighScore
	lda Score		;HighScore=Score;
	sta HighScore
	lda Score+1
	sta HighScore+1
	rts

GameOver
	lda #2
	sta VTAB
	lda #23
	sta HTAB
	ldx #9

DrawGameOverText
	lda GameOverText,x
	jsr DRAWCHAR
	dec HTAB
	dex
	bpl DrawGameOverText
	lda #7
	sta Loop

GameOverSound subroutine
	lda DELITEL
	pha
	lda #1
	sta DELIMO
.1	ldy DELIMO
.2	lda SPEAKER
	ldx DELITEL
.3	dex
	bne .3
	dey
	bne .2
	dec DELITEL
	bne .1
	lda #177
	jsr WAIT
	pla
	sbc #22
	dec Loop
	bne GameOverSound

				;Check if there is new highscore.
	lda Score+1		;At higher byte.
	cmp HighScore+1		;Compare.
	bcc DrawHighScore	;No.
	bne BrandNewHighScore	;If not Equal - it's higher always.
	lda Score		;If equal check if the lowbyte is
	cmp HighScore		;higher.
	bcc DrawHighScore	;No - there is no new highscore.

BrandNewHighScore
	jsr NewHighScore	;There is new highscore.
	lda #3
	sta VTAB
	lda #25
	sta HTAB
	ldx #13

DrawNewHighScoreText
	lda NewHighScoreText,x
	jsr DRAWCHAR
	dec HTAB
	dex
	bpl DrawNewHighScoreText
	lda X
	sta HTAB
	lda Y
	sta VTAB
      	ldx #11

HighScoreMusic
	txa
	pha
	lda #2
	jsr DRAWCHAR
	lda NewHighScoreNotes,x
	sta PITCH
	lda NewHighScoreDelays,x
	sta DURATION
	jsr PLAYSOUND
	lda #31
	jsr DRAWCHAR
	lda #177
	jsr WAIT
	pla
	tax
	dex
	bpl HighScoreMusic

DrawHighScore
	lda HighScore		;Copy the highscore.
	sta TempScore		;To the temporary score.
	lda HighScore+1		;cells (2 bytes = 1 word).
	sta TempScore+1		;The second byte.
	lda #34			;At 34th
	sta HTAB		;Horizontal position.
	jsr PrintHighScore	;From the second entrypoint.

	ldx X
	ldy Y
	lda #27
	jsr PUTXYCHAR		;DrawGrave at X,Y

	ldx #200
	ldy #15
				;Wait for button or keypress or a while.
				;200*15 cycles.
	lda STROBE		;Clear the keystrobe.
GameOverCycle
     	lda KEYBOARD		;Keyboard data (latched).
	cmp #$A0		;Check for pressed Space.
	bne NoSpace
NewGame	jsr InitGame
	jmp LevelBegin
NoSpace lda $C061		;Read Joystick button.
	bmi NewGame
	lda $C062               ;Read Joystick button 2.
	bmi NewGame
	lda #60
	jsr WAIT
	dex
	bne GameOverCycle
	dey
	bne GameOverCycle
	jmp TITLESC

InitGame
;	lda #1			;Select
;       sta LevelNumber		;First Level for a start. (Not used).
	lda #10			;10 flowers
	sta L			;and 10th position for Zorak.
	lda #InitialDelayTime	;Initial
	sta DELAYTIME		;Speed.
	lda #0			;Zero
	sta Score		;the
	sta Score+1		;Score.
	rts

;section DATA

PITCH    dc.b 0		;Placed here for exact timing.
DURATION dc.b 0		;Slower than accessing from ZeroPage.

ScreenTable	;Look-Up Table (LUT) with the Screen Line offsets.
	;At the second TextMode. (Can be any other - $6000 for example.)
	dc.w	$800	;Line 1
	dc.w	$880	;Line 2
	dc.w	$900	;Line 3
	dc.w	$980	;Line 4
	dc.w	$A00	;Line 5
	dc.w	$A80	;Line 6
	dc.w	$B00	;Line 7
	dc.w	$B80	;Line 8
	dc.w	$828	;Line 9
	dc.w	$8A8	;Line 10
	dc.w	$928	;Line 11
	dc.w	$9A8	;Line 12
	dc.w	$A28	;Line 13
	dc.w	$AA8	;Line 14
	dc.w	$B28	;Line 15
	dc.w	$BA8	;Line 16
	dc.w	$850	;Line 17
	dc.w	$8D0	;Line 18
	dc.w	$950	;Line 19
	dc.w	$9D0	;Line 20
	dc.w	$A50	;Line 21
	dc.w	$AD0	;Line 22
	dc.w	$B50	;Line 23
	dc.w	$BD0	;Line 24

ScoreText
	dc.b 51,67,79,82,69,26 ;Score:

HighScoreText
	dc.b 40,73,71,72,51,67,79,82,69,26 ;HighScore:

GameOverText
	dc.b 39,65,77,69,0,47,86,69,82,1 ;Game Over!

NewHighScoreText
	dc.b 46,69,87,0,40,73,71,72,51,67,79,82,69;,1 ;New HighScore!

;LUT for the digits calculation
PLNTBL	dc.b $01,$0A,$64,$E8,$10	;#1,#10,#100,#1000,#10000
PLNTBH	dc.b $00,$00,$00,$03,$27	;/1,/10,/100,/1000,/10000

NewHighScoreNotes
	dc.b 153,128,204,120,128,153,96,145,162,153,96,145

NewHighScoreDelays
	dc.b 170,30,90,120,30,90,120,30,90,120,30,90

;Title. Look something like below.
;
; /GGG\ /AAA\ RRRR\ DDDD\ EEEEE N\   N
; G   G A   A R   R D   D E     N\\  N
; G     AAAAA RRRR/ D   D EEEE  N \\ N
; G  GG A   A R\\   D   D E     N  \\N
; G   G A   A R \\  D   D E     N   \N
; \GGGG A   A R  \\ DDDD/ EEEEE N    N

Title	;Actual drawing.
 dc.b 0,0,11,10, 9,10,13,0,11,10, 9,10,13,0, 9,10, 9,10,13,0, 9,10, 9,10,13,0, 9,10, 9,10, 9,0, 9,14, 0, 0, 0,10,0,0
 dc.b 0,0, 9, 0, 0, 0, 9,0, 9, 0, 0, 0, 9,0, 9, 0, 0, 0, 9,0, 9, 0, 0, 0, 9,0, 9, 0, 0, 0, 0,0, 9,64,13, 0, 0,10,0,0
 dc.b 0,0, 9, 0, 0, 0, 0,0, 9,10, 9,10, 9,0, 9,10, 9,10,63,0, 9, 0, 0, 0, 9,0, 9,10, 9,10, 0,0, 9, 0,60,14, 0,10,0,0
 dc.b 0,0, 9, 0, 0,10,13,0, 9, 0, 0, 0, 9,0, 9,64,13, 0, 0,0, 9, 0, 0, 0, 9,0, 9, 0, 0, 0, 0,0, 9, 0, 0,64,13,10,0,0
 dc.b 0,0, 9, 0, 0, 0, 9,0, 9, 0, 0, 0, 9,0, 9, 0,60,14, 0,0, 9, 0, 0, 0, 9,0, 9, 0, 0, 0, 0,0, 9, 0, 0, 0,60,10,0,0
 dc.b 0,0,60,10, 9,10,63,0, 9, 0, 0, 0, 9,0, 9, 0, 0,64,13,0, 9,10, 9,10,63,0, 9,10, 9,10, 9,0, 9, 0, 0, 0, 0,10;,0,0

SubTitle	;Subtitle text.
 dc.b 0,0,2,0,29,0,52,72,73,83,0,"IS",0,"OUR",0,"HERO",1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 dc.b 0,0,4,0,29,0,47,"NE",0,"POINT",0,"FOR",0,"STEP",0,"ON",0,"THE",0,"GRASS",32,0,0
 dc.b 0,0,8,0,29,0,52,"EN",0,"POINTS",0,"FOR",0,"A",0,"PICKED",0,"FLOWER",32,0,0,0
 dc.b 0,0,3,0,29,0,33,0,"FELLOW",0,"WHO",0,"GUARDS",0,"THE",0,"GARDEN",32,0,0,0
 dc.b 0,0,7,0,29,0,47,"BSTACLES",0,"MAKING",0,"YOUR",0,"LIFE",0,"HARDER",32

ButtonPressText dc.b 48,"RESS",0,"BUTTON",0,"TO",0,"START",32

URLText dc.b 0,0,0,0,0,0,0,0,0,72,84,84,80,26,15,15,68,82,72,73,82,85,68,79,32,72,73,84,32,66,71,0,0,0,0,0,0,0,0,0

CopyrightText dc.b 28,35,30,0,18,16,16,21,0,66,89,0,0,54,69,78,84,90,73,83,76,65,86,0,0,0,52,90,86,69,84,75,79,86

	org $1700

Characters	;ilbm2asm GardenCharset.ilbm >GardenCharset.asm
	include GardenCharset.asm
END
